<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        修理システムにインストールされているプログラムを実行します。

    .DESCRIPTION
        修理システムにインストールされているプログラムを実行します。
#>
[CmdletBinding()]
Param
(
    [string]
    $ProgramId = ''
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}/../../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../../Modules/Utility"
Import-Module "${scriptDirectoryPath}/../../../Modules/Runner"


$RunOnTargetFromNand = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/RunOnTargetFromNand.exe"

Test-ParameterIsNotNullOrEmpty -Name "ProgramId" -Value $ProgramId

Test-EnsureExistPath $RunOnTargetFromNand

Invoke-CriticalCommand "& `"$RunOnTargetFromNand`" $TargetOption --id `"$ProgramId`""
