﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        修理システムを消去するCMAC付き初期化イメージ(*.initimgm)を作成します。

    .DESCRIPTION
        修理システムを消去するCMAC付き初期化イメージ(*.initimgm)を作成します。
#>
[CmdletBinding()]
Param
(
    [string]
    $BuildType = 'Develop',

    [string]
    $Platform = 'NX-NXFP2-a64',

    [string]
    $CmacKeyName = 'TestWsIssuerCmacKey',

    [string]
    $CmacKeyFile = ""
)

$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)

Import-Module "${scriptDirectoryPath}/../../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../../Modules/Utility"

$InitialImageName     = "ClearSafe"
$InitialImagePath     = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/InitialImages/$InitialImageName/$BuildType/$InitialImageName.initimg"
$MakeCmacInitialImage = "$(Get-NintendoSdkRootPath)/Integrate/Scripts/NX/Manufacturing//Make-CmacInitialImage.ps1"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

Test-EnsureExistPath $InitialImagePath

$AdditionalOption = "-CmacKeyFile $CmacKeyFile"
if([String]::IsNullOrEmpty($CmacKeyFile))
{
    $AdditionalOption = "-CmacKeyName $CmacKeyName"
}

$CmacFileTool           = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/CmacFileTool.exe"
$KeyFile                = "$(Get-NintendoSdkRootPath)/Integrate/Sources/Configs/CmacKey/$CmacKeyName.txt"
$SourceInitialImage     = "$InitialImagePath"
$OutputCmacInitialImage = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/InitialImages/$InitialImageName/$BuildType/$InitialImageName.initimgm"

if ($CmacKeyFile -ne "") {
    $KeyFile        = $CmacKeyFile
}

Write-Output "Key:"
Write-Output "     $KeyFile"
Write-Output "Input:"
Write-Output "    $SourceInitialImage"
Write-Output "Output:"
Write-Output "    $OutputCmacInitialImage"

Invoke-Expression "& `"$CmacFileTool`" append -i $SourceInitialImage -o $OutputCmacInitialImage --new-key $KeyFile"

