﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Invoke QSPI boot mode

    .DESCRIPTION
        Invoke QSPI boot mode by HostBridg with QSPI Boot Image.
#>
[CmdletBinding()]
Param
(
    # The QSPI boot image.
    [Parameter(Mandatory=$true)]
    [string]
    $QspiBootImage,

    # The host IP address pattern as RegularExpression
    [Parameter(Mandatory=$true)]
    [string]
    $AddressPattern = '.*'
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/HostBridge"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"

$QspiRecoveryBootToolPath = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/RecoveryBoot.exe"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

Test-EnsureExistPath $QspiBootImage
$TargetAddress = Get-SigleTargetAddress -AddressPattern $AddressPattern
Invoke-CriticalCommand "& `"$QspiRecoveryBootToolPath`" --target $TargetAddress --image `"$QspiBootImage`""
