<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Create PseudoProdKey Qspi Image

    .DESCRIPTION
        Create PseudoProdKey Qspi Image
#>
[CmdletBinding()]
Param
(
    [string]
    $KeyType = 'K6',

    [string]
    $ConnectionType = 'Manu',

    [string]
    $SignedType = 'Signed',

    [string]
    $BootType = 'ManuBoot',

    [string]
    $StorageSize = '32G',

    [string]
    $DeveloperType = 'ManufacturingTest',

    [string]
    $BuildType = 'Release',

    [string]
    $Platform = 'NX-NXFP2-a64',

    [string]
    $SystemPartitionKey = '',

    [string]
    $Suffix = ''
)

$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)

if($Suffix.Length -ne 0)
{
    Write-Host "  Suffix:         $Suffix"
}

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"

$QspiBootImageName   = "RecoveryWriter-$KeyType-$ConnectionType-$SignedType";
$SystemPartitionName = "Manufacture1stInitializeSystemPartition"
$MakeQspiBootImage    = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/MakeQspiBootImage.exe"
$QspiBootImagePath   = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/SystemImages/QspiBootImages/$QspiBootImageName/$BuildType/$QspiBootImageName$Suffix.qspi.img"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

if ($KeyType -eq "K6") {
    $QspiBootArchivePath = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/FirmwareArchives/$QspiBootImageName/$BuildType/$QspiBootImageName$Suffix.prod.nfa"
    $SignedSystemPartitionPath = "$(Get-NintendoSdkRootPath)/Externals/NxProdBinaries/SignedSystemPartition/$SystemPartitionName$Suffix.prod.img"
}
else {
    $QspiBootArchivePath = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/FirmwareArchives/$QspiBootImageName/$BuildType/$QspiBootImageName$Suffix.nfa"
    $SignedSystemPartitionPath = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/SystemImages/SystemPartition/$SystemPartitionName/$BuildType/$SystemPartitionName$Suffix.fatimg"
}

if ( ($KeyType -ne "K6") -and ($SystemPartitionKey -eq '') )
{
    $SystemPartitionKey = "$(Get-NintendoSdkRootPath)/Externals/NxSystemImages/Recovery/SystemPartitionKey.bin"
}

Test-EnsureExistPath $QspiBootArchivePath
Test-EnsureExistPath $MakeQspiBootImage
Test-EnsureExistPath $SystemPartitionKey
Test-EnsureExistPath $SignedSystemPartitionPath

$QspiImageDirectoryPath = [System.IO.Path]::GetDirectoryName($QspiBootImagePath)
if (!(Test-Path $QspiImageDirectoryPath)) {
    New-Item $QspiImageDirectoryPath -itemType Directory | Out-Null
}

Invoke-Expression "& `"$MakeQspiBootImage`" -i `"$QspiBootArchivePath`" -o `"$QspiBootImagePath`" --key `"$SystemPartitionKey`" --system-partition `"$SignedSystemPartitionPath`" --system-partition-alignment 16MiB"
