<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Initialize edev by system updater.

    .DESCRIPTION
        Initialize edev by system updater.
#>
[CmdletBinding()]
Param
(
    [string]
    $KeyType = 'K5',

    [string]
    $ConnectionType = 'Manu',

    [string]
    $SignedType = 'Signed',

    [string]
    $BootType = 'ManuBoot',

    [string]
    $StorageSize = '64G',

    [string]
    $DeveloperType = 'ManufacturingTest',

    [string]
    $BuildType = 'Release',

    [string]
    $Platform = 'NX-NXFP2-a64',

    [string]
    $CmacKeyName = "TestWsIssuerCmacKey"
)

$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"

$InitialImageName     = "NX-$KeyType-$ConnectionType-$SignedType-$BootType-$StorageSize-$DeveloperType"
$InitialImagePath     = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/InitialImages/$InitialImageName/$BuildType/$InitialImageName.initimg"
$InitialArchiveName   = "$InitialImageName"
$InitialArchivePath   = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/FirmwareArchives/$InitialArchiveName/$BuildType/$InitialArchiveName.nfa"
$MergedArchiveName    = "$InitialImageName-Merged"
$MergedArchivePath    = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/FirmwareArchives/$InitialArchiveName/$BuildType/$MergedArchiveName.nfa"
$ContentsListPath     = "${scriptDirectoryPath}/Manufacture-ProdTestingList.yml"
$MakeFirmwareArchive  = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/MakeFirmwareArchive/MakeFirmwareArchive.exe"
$MakeInitialImage     = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/MakeInitialImage.exe"
$MakeCmacInitialImage = "$($scriptDirectoryPath)/Make-CmacInitialImage.ps1"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

Test-EnsureExistPath $InitialArchivePath
Test-EnsureExistPath $ContentsListPath

Invoke-Expression "& `"$MakeFirmwareArchive`" createnfa -i `"$ContentsListPath`" -i `"$InitialArchivePath`" -o `"$MergedArchivePath`""

$InitialImageDirectoryPath = [System.IO.Path]::GetDirectoryName($InitialImagePath)
if (!(Test-Path $InitialImageDirectoryPath)) {
    New-Item $InitialImageDirectoryPath -itemType Directory | Out-Null
}
Invoke-Expression "& `"$MakeInitialImage`" -i `"$MergedArchivePath`" -o `"$InitialImagePath`""

Invoke-Expression "& `"$MakeCmacInitialImage`" -BuildType $BuildType -Platform $Platform -KeyType $KeyType -ConnectionType $ConnectionType -BootType $BootType -SignedType $SignedType -StorageSize $StorageSize -DeveloperType $DeveloperType -CmacKeyName $CmacKeyName "

Remove-Item $MergedArchivePath

