<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Make InitialImage with CMAC.

    .DESCRIPTION
        Make InitialImage with CMAC.
#>
[CmdletBinding()]
Param
(
    [string]
    $BuildType = 'Release',
    
    [string]
    $Platform = 'NX-NXFP2-a64',

    [string]
    $KeyType = "K5",

    [string]
    $CmacKeyName = "TestWsIssuerCmacKey",

    [string]
    $CmacKeyFile = ""
)

$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($MyInvocation.MyCommand.Path)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"

$CmacFileTool           = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/CmacFileTool.exe"
$KeyFile                = "$(Get-NintendoSdkRootPath)/Integrate/Sources/Configs/CmacKey/$CmacKeyName.txt"
$InitialImageName       = "BreakBct"
$SourceInitialImage     = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/InitialImages/$InitialImageName/$BuildType/$InitialImageName.initimg"
$OutputCmacInitialImage = "$(Get-NintendoSdkRootPath)/Programs/Eris/Outputs/$Platform/InitialImages/$InitialImageName/$BuildType/$InitialImageName.$KeyType.initimgm"

if ($CmacKeyFile -ne "") {
    $KeyFile        = $CmacKeyFile
}

Write-Output "Key:"
Write-Output "     $KeyFile"
Write-Output "Input:"
Write-Output "    $SourceInitialImage"
Write-Output "Output:"
Write-Output "    $OutputCmacInitialImage"

Invoke-Expression "& `"$CmacFileTool`" append -i $SourceInitialImage -o $OutputCmacInitialImage --new-key $KeyFile"
