﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Write boot config by QSPI boot

    .DESCRIPTION
        Write boot config by QSPI boot.
#>
[CmdletBinding()]
Param
(
    [string]
    $AddressPattern = '.*',

    [string]
    $TargetAddress,

    [switch]
    $All
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

Import-Module "${scriptDirectoryPath}/../../Modules/Error"
Import-Module "${scriptDirectoryPath}/../../Modules/Path"
Import-Module "${scriptDirectoryPath}/../../Modules/HostBridge"
Import-Module "${scriptDirectoryPath}/../../Modules/BootConfig"
Import-Module "${scriptDirectoryPath}/../../Modules/Utility"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

if([String]::IsNullOrEmpty($TargetAddress))
{
    $TargetAddress = Get-SigleTargetAddress -AddressPattern $AddressPattern
}

Write-ProperBootConfig $TargetAddress -All:$All
