﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Runnner Module

    .DESCRIPTION
        This file defines functions for Runner operations
#>

$moduleFilePath = $MyInvocation.MyCommand.Path
$modulePath     = [System.IO.Path]::GetDirectoryName($moduleFilePath)
$moduleRootPath = [System.IO.Path]::GetDirectoryName($modulePath)

Import-Module "${moduleRootPath}\Path"
Import-Module "${moduleRootPath}\HostBridge"
Import-Module "${moduleRootPath}\Utility"

<#
    .SYNOPSIS
        Reset the Target
#>
function Reset-Target
{
    param
    (
        [Parameter(Mandatory=$true)]
        $Platform,
        
        # Set the HostBridge address as RegularExpression.
        [string]
        $AddressPattern = $env:TARGET_ADDRESS_PATTERN
    )

    if (-not $AddressPattern)
    {
        # If AddressPattern is not specified and env:TARGET_ADDRESS_PATTERN is not difined
        $AddressPattern = "169.*";
    }

    $controlTargetPath = "D:\Tools\ControlTarget\ControlTarget.exe"
    switch ($Platform)
    {
        "jetson-tk1"
        {
            Start-Process $controlTargetPath -ArgumentList "reset"
        }
        "jetson-tk2"
        {
            Start-Process $controlTargetPath -ArgumentList "reset" -NoNewWindow -Wait
        }
        "jetson-tk2-a64"
        {
            Start-Process $controlTargetPath -ArgumentList "reset" -NoNewWindow -Wait
        }
        "NXOnJetsonTk2"
        {
            Start-Process $controlTargetPath -ArgumentList "reset" -NoNewWindow -Wait
        }
        "NX-NXFP2-a32"
        {
            $TargetAddress = Get-SigleTargetAddress -AddressPattern $AddressPattern
            Restart-TargetByHostBridge $TargetAddress
        }
        "NX-NXFP2-a64"
        {
            $TargetAddress = Get-SigleTargetAddress -AddressPattern $AddressPattern
            Restart-TargetByHostBridge $TargetAddress
        }
        default
        {
            throw "'${Platform}' is not supportted."
        }
    }
}

Export-ModuleMember -Function Reset-Target

<#
    .SYNOPSIS
        Unregister All Targets from TargetManager
#>
function Unregister-AllTargets
{
    param
    (
    )

    $controlTargetPath = "$(Get-NintendoSdkRootPath)/Tools/CommandLineTools/ControlTarget.exe"
    Invoke-CriticalCommand "& `"$controlTargetPath`" unregister-all"        
}

Export-ModuleMember -Function Unregister-AllTargets
