﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Git Module

    .DESCRIPTION
        This file defines functions for git operations
#>


$moduleFilePath = $MyInvocation.MyCommand.Path
$modulePath     = [System.IO.Path]::GetDirectoryName($moduleFilePath)
$moduleRootPath = [System.IO.Path]::GetDirectoryName($modulePath)

Import-Module "${moduleRootPath}\Path"

<#
    .SYNOPSIS
        Returns the current branch name of NintendoSDK

    .OUTPUTS
        String instance
#>
function Get-GitNintendoSdkBranch
{
    $gitBranch = ${env:GIT_BRANCH}

    if ( -not $gitBranch )
    {
        Push-Location

        Set-Location (Get-NintendoSdkRootPath)

        $gitBranch = & (Get-GitPath) symbolic-ref HEAD 2> $null

        Pop-Location

        if ( $LastExitCode -ne 0 ) { throw "failed to get branch name" }
    }

    $prefix = "refs/heads/"
    if ( $gitBranch.Length -gt $prefix.Length -and
         $gitBranch.StartsWith($prefix) )
    {
        $gitBranch = $gitBranch.SubString($prefix.Length)
    }

    $featurePrefix = "feature/"
    if ( $gitBranch.Length -gt $featurePrefix.Length -and
         $gitBranch.StartsWith($featurePrefix) )
    {
        $gitBranch = $gitBranch.SubString($featurePrefix.Length)
    }

    return $gitBranch
}
Export-ModuleMember -Function Get-GitNintendoSdkBranch

<#
    .SYNOPSIS
        Returns the current commit hash of NintendoSDK

    .OUTPUTS
        String instance
#>
function Get-GitNintendoSdkCommit
{
    $gitCommit = ${env:GIT_COMMIT}

    if ( -not $gitCommit )
    {
        Push-Location

        Set-Location (Get-NintendoSdkRootPath)

        $gitCommit = & (Get-GitPath) rev-parse HEAD 2> $null

        Pop-Location

        if ( $LastExitCode -ne 0 ) { throw "failed to get commit hash" }
    }

    if ( $gitCommit.Length -gt 7 ) { $gitCommit = $gitCommit.SubString(0, 7) }

    return $gitCommit
}
Export-ModuleMember -Function Get-GitNintendoSdkCommit
