﻿<#
    Copyright (C)Nintendo. All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.
 
    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
    ローカライズパッケージを作成します。

    .DESCRIPTION
    ローカライズパッケージを作成します。

    .INPUTS
    なし。

    .OUTPUTS
    なし。
#>
[CmdletBinding()]
Param(
    # 翻訳用リポジトリのルートを指定します。
    [parameter(Mandatory = $true,
               Position = 0)]
    [string] $TranslationRoot,

    # 言語(日本語は 'ja', 英語は 'en')を指定します。
    [parameter(Mandatory = $true,
               Position = 1)]
    [string] $Lang
)

$sigloRoot = (Join-Path $MyInvocation.MyCommand.Path ../../../.. | Resolve-Path).Path

Import-Module $sigloRoot/Integrate/Scripts/Modules/Localize

#
# ローカライズされたファイルで存在するファイルを置換
#
Get-ChildItem $TranslationRoot/$Lang/ApiReference |
ForEach-Object {
    $dirName = $_.Name
    Set-ExistFile $TranslationRoot/$Lang/ApiReference/$dirName $sigloRoot/$dirName
}
