﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>
<#
    .SYNOPSIS
        Invoke Test-SigloEnvironment.ps1 and format the result.

    .PARAMETER TestLevel
        Every test whose test level is smaller than or equal to this value will be executed.
#>

param
(
    [int]$TestLevel = [int]::MaxValue
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

$errors = & $scriptDirectoryPath\Test-SigloEnvironment.ps1 $TestLevel | Where-Object { !$_.Successful }
$errors | Format-List Name, Description, Error

if ($errors -eq $null)
{
    exit 0
}
else
{
    exit 1
}
