<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>

<#
    .SYNOPSIS
        Invoke Check Gpu Resource Test

    .DESCRIPTION
        Run Check Gpu Resource Test.
#>

param
(
    [int]
    # The number of seconds before it times out.
    $Timeout = 5000,

    [string]
    # Test path
    $AppPath = "Tests\Outputs\NX-NXFP2-a64\Tests\testGfx_CheckGpuResourceApp\Release\testGfx_CheckGpuResourceApp.nsp",
    $OaPath = "Tests\Outputs\NX-NXFP2-a64\Tests\testGfx_CheckGpuResourceOa\Release\testGfx_CheckGpuResourceOa.nsp",
    $DummyAppPath = "Tests\Outputs\NX-NXFP2-a64\Tests\dummyApp\Release\dummyApp.nsp",
    $DummyOaPath = "Tests\Outputs\NX-NXFP2-a64\Tests\dummyOa\Release\dummyOa.nsp",

    [int]
    # Test pattern
    $Dummy1 = 1,
    $Dummy2 = 2,

    [int]
    # Framework pattern
    $DeferredSubmission = 1,
    $DeferredExecution = 2,

    [int]
    # ダミーAPP,OA を起動してからテスト用APP,OA を起動するまでの待機時間
    $IntervalSeconds = 5
)

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)
Import-Module "${scriptDirectoryPath}\Modules\Error"
Import-Module "${scriptDirectoryPath}\Modules\Path"
Import-Module "${scriptDirectoryPath}\Modules\TargetManager"
Import-Module "${scriptDirectoryPath}\Modules\Runner"
Import-Module "${scriptDirectoryPath}\Modules\HostBridge"
Import-Module "${scriptDirectoryPath}\Modules\Utility"

trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

# nca file full path
$AppName = [System.IO.Path]::Combine((Get-NintendoSdkRootPath), ${AppPath})
$OaName = [System.IO.Path]::Combine((Get-NintendoSdkRootPath), ${OaPath})
$DummyAppName = [System.IO.Path]::Combine((Get-NintendoSdkRootPath), ${DummyAppPath})
$DummyOaName = [System.IO.Path]::Combine((Get-NintendoSdkRootPath), ${DummyOaPath})

$TestResult = 0


function TestApp($presentInterval, $framework, $dummyIndex)
{
    Invoke-Expression "& `"$RunOnTarget`" $DummyOaName $presentInterval $framework $dummyIndex --failure-timeout $Timeout --no-wait"
    Start-Sleep -Seconds $IntervalSeconds
    Invoke-Expression "& `"$RunOnTarget`" $AppName $presentInterval $framework $dummyIndex --failure-timeout $Timeout --suppress-auto-kill"
    $TestResult += $LastExitCode
    Invoke-CriticalCommand "& `"$ControlTarget`" reset --hard"
}

function TestOa($presentInterval, $framework, $dummyIndex)
{
    Invoke-Expression "& `"$RunOnTarget`" $DummyAppName $presentInterval $framework $dummyIndex --failure-timeout $Timeout --no-wait"
    Start-Sleep -Seconds $IntervalSeconds
    Invoke-Expression "& `"$RunOnTarget`" $OaName $presentInterval $framework $dummyIndex --failure-timeout $Timeout --suppress-auto-kill"
    $TestResult += $LastExitCode
    Invoke-CriticalCommand "& `"$ControlTarget`" reset --hard"
}

try
{
    $RunOnTarget = "$(Get-NintendoSdkRootPath)\Tools\CommandLineTools\RunOnTarget.exe"
    $ControlTarget = "$(Get-NintendoSdkRootPath)\Tools\CommandLineTools\ControlTarget.exe"
    $DevMenuCommandSystem = "$(Get-NintendoSdkRootPath)\Programs\Eris\Outputs\NX-NXFP2-a64\TargetTools\DevMenuCommandSystem\Release\DevMenuCommandSystem.nsp"

    Invoke-CriticalCommand "& `"$ControlTarget`" reset --hard"

    # DevOverlayDisp を無効化する
    Invoke-Expression "& `"$RunOnTarget`" $DevMenuCommandSystem systemprogram set-overlay-disp-program 0x0000000000000000"
    Invoke-CriticalCommand "& `"$ControlTarget`" reset --hard"


    # PresentInterval = 1 && DeferredSubmission の場合のテスト
    # APP のテスト(OA が描画する場合)
    TestApp(1, $DeferredSubmission, $Dummy1)
    # APP のテスト(OA が描画しない場合)
    TestApp(1, $DeferredSubmission, $Dummy2)
    # OA のテスト(APP の GPU 負荷が高い場合)
    TestOa(1, $DeferredSubmission, $Dummy1)
    # OA のテスト(APP の GPU 負荷が低い場合)
    TestOa(1, $DeferredSubmission, $Dummy2)

    # PresentInterval = 1 && DeferredExecution の場合のテスト
    # APP のテスト(OA が描画する場合)
    TestApp(1, $DeferredExecution, $Dummy1)
    # APP のテスト(OA が描画しない場合)
    TestApp(1, $DeferredExecution, $Dummy2)
    # OA のテスト(APP の GPU 負荷が高い場合)
    TestOa(1, $DeferredExecution, $Dummy1)
    # OA のテスト(APP の GPU 負荷が低い場合)
    TestOa(1, $DeferredExecution, $Dummy2)

    # PresentInterval = 2 && DeferredSubmission の場合のテスト
    # APP のテスト(OA が描画する場合)
    TestApp(2, $DeferredSubmission, $Dummy1)
    # APP のテスト(OA が描画しない場合)
    TestApp(2, $DeferredSubmission, $Dummy2)
    # OA のテスト(APP の GPU 負荷が高い場合)
    TestOa(2, $DeferredSubmission, $Dummy1)
    # OA のテスト(APP の GPU 負荷が低い場合)
    TestOa(2, $DeferredSubmission, $Dummy2)

    # PresentInterval = 2 && DeferredExecution の場合のテスト
    # APP のテスト(OA が描画する場合)
    TestApp(2, $DeferredExecution, $Dummy1)
    # APP のテスト(OA が描画しない場合)
    TestApp(2, $DeferredExecution, $Dummy2)
    # OA のテスト(APP の GPU 負荷が高い場合)
    TestOa(2, $DeferredExecution, $Dummy1)
    # OA のテスト(APP の GPU 負荷が低い場合)
    TestOa(2, $DeferredExecution, $Dummy2)


    # DevOverlayDisp を有効化する
    Invoke-Expression "& `"$RunOnTarget`" $DevMenuCommandSystem systemprogram set-overlay-disp-program 0x0100000000002099"
    Invoke-CriticalCommand "& `"$ControlTarget`" reset --hard"
}
finally
{
}

# Pass exitCode to TestRunner's result
exit $TestResult
