@echo off
setlocal

set INSTALLER=%~1

set PARAMETERS=--passive ^
 --norestart ^
 --wait ^
 --add Microsoft.VisualStudio.Workload.CoreEditor ^
 --add Microsoft.VisualStudio.Workload.ManagedDesktop;includeRecommended ^
 --add Microsoft.VisualStudio.Workload.NativeDesktop;includeRecommended ^
 --add Microsoft.VisualStudio.Component.VC.CLI.Support ^
 --add Microsoft.VisualStudio.Component.Windows81SDK ^
 --add Microsoft.VisualStudio.Component.Windows10SDK.10240 ^
 --add Microsoft.VisualStudio.Component.Windows10SDK.15063.Desktop ^
 --add Microsoft.VisualStudio.Workload.VisualStudioExtension ^
 --add Microsoft.VisualStudio.Component.VC.Tools.14.11 ^
 --add Microsoft.VisualStudio.Component.VC.Tools.14.12 ^
 --addProductLang ja-JP ^
 --addProductLang en-US

shift
:parse
if "%~1" neq "" (
    set PARAMETERS=%PARAMETERS% %1
    shift
    goto :parse
)


if not exist "%INSTALLER%" goto :installer_not_specified

"%INSTALLER%" %PARAMETERS%

if "%ERRORLEVEL%"=="3010" (
    echo ***************
    echo REBOOT REQUIRED
    echo ***************
    echo.
    echo Installation successfull, but install requires reboot before it can be used.

    pause
    exit /b 3010
)

if ERRORLEVEL 1 (
    echo ***************
    echo      ERROR
    echo ***************
    echo The installer returned error: %ERRORLEVEL%

    pause
    exit /b %errorlevel%
)

echo Installation successfull.

exit /b 0


:installer_not_specified
echo Please drag-and-drop the installer file of Visual Studio 2017 Professional to this bat file.
pause
exit /b 1
