﻿<#
    Copyright (C)Nintendo All rights reserved.

    These coded instructions, statements, and computer programs contain proprietary
    information of Nintendo and/or its licensed developers and are protected by
    national and international copyright laws. They may not be disclosed to third
    parties or copied or duplicated in any form, in whole or in part, without the
    prior written consent of Nintendo.

    The content herein is highly confidential and should be handled accordingly.
#>
<#
    .SYNOPSIS
        Adds packages under the specified path into the Siglo common NuGet feed.

    .PARAMETER packageSearchPath
        Specifies the path to the package or the directory containing packages.

    .PARAMETER force
        Do not prompt for confirmation.
#>

param
(
    [Parameter(Mandatory=$true, Position = 0)]
    [string]
    $packageSearchPath,

    [switch]
    $force
)

$ErrorActionPreference = "Stop"
trap [Exception]
{
    Write-ErrorRecord $_
    exit 1
}

#
# Script globals
#

$scriptPath          = $MyInvocation.MyCommand.Path
$scriptDirectoryPath = [System.IO.Path]::GetDirectoryName($scriptPath)

#
# Imports
#

Import-Module "${scriptDirectoryPath}\Modules\Error"
Import-Module "${scriptDirectoryPath}\Modules\Path"
Import-Module "${scriptDirectoryPath}\Modules\NuGet"

function Read-YesNo()
{
    param
    (
        [Parameter(Mandatory=$true)]
        [string]
        $prompt
    )    

    while ($true)
    {
        $reply = Read-Host -Prompt "$prompt (y/n)"
        if ($reply -eq "y")
        {
            return $true
        }
        elseif ($reply -eq "n")
        {
            return $false
        }
    }
}

#
# Main
#
$nugetPath = Get-NuGetPath
$feedPath = Get-SigloNuGetFeedOrigin
$csiPath = Get-CsiPath

$packagesPath = & $csiPath "${scriptDirectoryPath}\Build\EnumeratePackages.csx" $packageSearchPath
if ($LastExitCode)
{
    exit 1
}

foreach ($x in $packagesPath)
{
    Write-Output $x
}
Write-Output ""
Write-Output "The above NuGet packages will be added to $feedPath."

if (-not $force)
{
    $proceed = Read-YesNo "Are you okay to proceed?"
    if (-not $proceed)
    {
        exit 1
    }
}

foreach ($x in $packagesPath)
{
    Add-NuGetPackage $x -Source $feedPath
}

exit 0
