:: ---------------------------------------------------------------------------
:: Copyright (C)2014 Nintendo Co., Ltd.  All rights reserved.
::
:: These coded instructions, statements, and computer programs contain
:: proprietary information of Nintendo of America Inc. and/or Nintendo
:: Company Ltd., and are protected by Federal copyright law.  They may
:: not be disclosed to third parties or copied or duplicated in any form,
:: in whole or in part, without the prior written consent of Nintendo.
:: ---------------------------------------------------------------------------

@echo off

setlocal

:: ---------------------------------------------------------------------------
:: Setup Siglo mirror.
:: ---------------------------------------------------------------------------
echo Setup Siglo mirror.

if defined SIGLO_NO_MIRROR (
    echo Not using Siglo mirror.
    git config --global --unset url.ssh://mirror@buildtools.ntd.nintendo.com/siglo/.insteadOf
    git config --global --unset url.ssh://mirror@buildtools.ntd.nintendo.com/sigloprivate/.insteadOf
    git config --global --unset url.ssh://git@spdlybra.nintendo.co.jp:7999.pushinsteadof
    git config --global --unset url.ssh://git@spdlybra.nintendo.co.jp:7999/siglo/mmtest.git.insteadof
    git config --global --unset url.ssh://git@spdlybra.nintendo.co.jp:7999/siglo/vfx.git.insteadof
    goto END
)

for /f "delims=@ tokens=2" %%a in ('git config user.email') do set "EMAIL_DOMAIN=%%a"

if not defined EMAIL_DOMAIN (
    echo WARNING: Could not find e-mail address. Please set your e-mail address to gitconfig.
    goto END
)

:: call subroutine.
call :CASE_%EMAIL_DOMAIN% 2>NUL

if not %ERRORLEVEL% == 0 (
    call :DEFAULT
)

goto END

:: ---------------------------------------------------------------------------
:: table
:: ---------------------------------------------------------------------------

:: ---------------------------------------------------------------------------
:CASE_nintendo.com
:CASE_noa.nintendo.com

    echo Setup attributes as 'CoDevelopers'.
    git config exrepo-m.attributes "CoDevelopers"
    goto END

:: ---------------------------------------------------------------------------
:CASE_ntd.nintendo.com

    for /f "delims=. tokens=1" %%a in ('git config user.email') do set "EMAIL_PREFIX=%%a"

    call :CASE_%EMAIL_PREFIX%@ntd.nintendo.com 2>NUL

    if not %ERRORLEVEL% == 0 (
        echo Set NTD Siglo and Sigloprivate mirror.
        git config --global url.ssh://mirror@buildtools.ntd.nintendo.com/siglo/.insteadOf ssh://git@spdlybra.nintendo.co.jp:7999/siglo/
        git config --global url.ssh://mirror@buildtools.ntd.nintendo.com/sigloprivate/.insteadOf ssh://git@spdlybra.nintendo.co.jp:7999/sigloprivate/
        git config --global url.ssh://git@spdlybra.nintendo.co.jp:7999.pushinsteadof ssh://git@spdlybra.nintendo.co.jp:7999
        git config --global url.ssh://git@spdlybra.nintendo.co.jp:7999/siglo/mmtest.git.insteadof ssh://git@spdlybra.nintendo.co.jp:7999/siglo/mmtest.git
        git config --global url.ssh://git@spdlybra.nintendo.co.jp:7999/siglo/vfx.git.insteadof ssh://git@spdlybra.nintendo.co.jp:7999/siglo/vfx.git
        set ERRORLEVEL=0
    )

    goto END

:: ---------------------------------------------------------------------------
:CASE_c@ntd.nintendo.com
:CASE_v@ntd.nintendo.com

    echo Set NTD Siglo mirror.
    git config --global url.ssh://mirror@buildtools.ntd.nintendo.com/siglo/.insteadOf ssh://git@spdlybra.nintendo.co.jp:7999/siglo/
    git config --global url.ssh://git@spdlybra.nintendo.co.jp:7999.pushinsteadof ssh://git@spdlybra.nintendo.co.jp:7999
    git config --global url.ssh://git@spdlybra.nintendo.co.jp:7999/siglo/mmtest.git.insteadof ssh://git@spdlybra.nintendo.co.jp:7999/siglo/mmtest.git
    git config --global url.ssh://git@spdlybra.nintendo.co.jp:7999/siglo/vfx.git.insteadof ssh://git@spdlybra.nintendo.co.jp:7999/siglo/vfx.git
    goto END

:: ---------------------------------------------------------------------------
:DEFAULT

    echo No Siglo mirror set.
    goto END

:: ---------------------------------------------------------------------------

:END
