:: ---------------------------------------------------------------------------
:: Copyright (C)2014 Nintendo Co., Ltd.  All rights reserved.
::
:: These coded instructions, statements, and computer programs contain
:: proprietary information of Nintendo of America Inc. and/or Nintendo
:: Company Ltd., and are protected by Federal copyright law.  They may
:: not be disclosed to third parties or copied or duplicated in any form,
:: in whole or in part, without the prior written consent of Nintendo.
:: ---------------------------------------------------------------------------

@echo off

setlocal

set SCRIPT_DIRECTORY=%~dp0
set REPOSITORY_ROOT=%~dp0\..\..\..\..\
set DOT_GIT_DIRECTORY=%REPOSITORY_ROOT%.git\

:: ---------------------------------------------------------------------------
:: Setup GitExternalStorage.
:: ---------------------------------------------------------------------------
echo Setup GitExternalStorage.

set EXSTORAGE_SRC_DIRECTORY=%SCRIPT_DIRECTORY%
set EXSTORAGE_DEST_DIRECTORY=%DOT_GIT_DIRECTORY%GitExternalStorage

if not exist "%EXSTORAGE_DEST_DIRECTORY%" (
    mkdir "%EXSTORAGE_DEST_DIRECTORY%"
)
xcopy /q /y /i "%EXSTORAGE_SRC_DIRECTORY%GitExternalStorage.exe"    "%EXSTORAGE_DEST_DIRECTORY%" >nul
xcopy /q /y /i "%EXSTORAGE_SRC_DIRECTORY%Libgit2.dll"               "%EXSTORAGE_DEST_DIRECTORY%" >nul

:: ---------------------------------------------------------------------------
:: Setup .git/config settings.
:: ---------------------------------------------------------------------------
echo Setup .git/config settings.

:: set command alias
git config alias.exstorage "!.git/GitExternalStorage/GitExternalStorage.exe"

:: set filter
git config filter.GitExternalStorage.clean  "git exstorage filter-clean"
git config filter.GitExternalStorage.smudge "git exstorage filter-smudge"

:: set configs
git config GitExternalStorage.transport     local
git config GitExternalStorage.autodownload  true
git config GitExternalStorage.localpath     "\\devdatasrv.ncl.nintendo.co.jp\siglo-git$\sdk"

:: ---------------------------------------------------------------------------
:: Setup pre-push hook script.
:: ---------------------------------------------------------------------------
echo Setup pre-push hook script.

if not exist "%DOT_GIT_DIRECTORY%hooks\" (
    mkdir "%DOT_GIT_DIRECTORY%hooks\"
)
xcopy /q /y /i "%SCRIPT_DIRECTORY%pre-push" "%DOT_GIT_DIRECTORY%hooks\" >nul

:: ---------------------------------------------------------------------------
:: Setup CDN configuration.
:: ---------------------------------------------------------------------------
echo Setup CDN configuration.

:: get domain name of e-mail address
for /f "delims=@ tokens=2" %%a in ('git config user.email') do set "EMAIL_DOMAIN=%%a"

echo Your e-mail domain: %EMAIL_DOMAIN%

call :CASE_%EMAIL_DOMAIN% 2>NUL

if not %ERRORLEVEL% == 0 (
    call :DEFAULT
)
goto END

:CASE_ntd.nintendo.com
    echo Setting NTD CDN.
    git config gitexternalstorage.cdn.transport local
    git config gitexternalstorage.cdn.localpath "\\noa01dept01.noa.nintendo.com\ntd_dept\projects\n_proj\Siglo\exstorage"
    goto END

:DEFAULT
    echo No CDN set.
    goto END

:END
