:: ---------------------------------------------------------------------------
:: Copyright (C)2014 Nintendo Co., Ltd.  All rights reserved.
::
:: These coded instructions, statements, and computer programs contain
:: proprietary information of Nintendo of America Inc. and/or Nintendo
:: Company Ltd., and are protected by Federal copyright law.  They may
:: not be disclosed to third parties or copied or duplicated in any form,
:: in whole or in part, without the prior written consent of Nintendo.
:: ---------------------------------------------------------------------------

@echo off

setlocal

set SCRIPT_DIRECTORY=%~dp0
set REPOSITORY_ROOT=%~dp0..\..\..\..\
set DOT_GIT_DIRECTORY=%REPOSITORY_ROOT%.git\

:: ---------------------------------------------------------------------------
:: Setup GitExternalRepositoryManager.
:: ---------------------------------------------------------------------------
echo Setup GitExternalRepositoryManager.

set EXREPO_M_SRC_DIRECTORY=%SCRIPT_DIRECTORY%
set EXREPO_M_DEST_DIRECTORY=%DOT_GIT_DIRECTORY%GitExternalRepositoryManager

if not exist "%EXREPO_M_DEST_DIRECTORY%" (
    mkdir "%EXREPO_M_DEST_DIRECTORY%"
)
xcopy /q /y /i "%EXREPO_M_SRC_DIRECTORY%GitExternalRepositoryManager.exe"    "%EXREPO_M_DEST_DIRECTORY%" >nul
xcopy /q /y /i "%EXREPO_M_SRC_DIRECTORY%System.Interactive.dll"       "%EXREPO_M_DEST_DIRECTORY%" >nul
xcopy /q /y /i "%EXREPO_M_SRC_DIRECTORY%ToolFoundation.dll"           "%EXREPO_M_DEST_DIRECTORY%" >nul

:: ---------------------------------------------------------------------------
:: Setup .git/config settings.
:: ---------------------------------------------------------------------------
echo Setup .git/config settings.

:: set command alias
git config alias.exrepo-m "!.git/GitExternalRepositoryManager/GitExternalRepositoryManager.exe"

:: set directory
git config exrepo-m.directory "Integrate/Repository/GitExternalRepositoryManagerList"

:: set attributes
FOR /F %%a IN ('git config --get exrepo-m.attributes') DO set "EXREPO_M_CONFIG_ATTRIBUTES=%%a"

if not defined EXREPO_M_CONFIG_ATTRIBUTES (
    call "%SCRIPT_DIRECTORY%autoconfig.cmd"
)

:: ---------------------------------------------------------------------------
:: Setup post-checkout hook script.
:: ---------------------------------------------------------------------------
echo Setup post-checkout hook script.

if not exist "%DOT_GIT_DIRECTORY%hooks\" (
    mkdir "%DOT_GIT_DIRECTORY%hooks\"
)
xcopy /q /y /i "%SCRIPT_DIRECTORY%post-checkout" "%DOT_GIT_DIRECTORY%hooks\" >nul
xcopy /q /y /i "%SCRIPT_DIRECTORY%post-merge"    "%DOT_GIT_DIRECTORY%hooks\" >nul