:: ---------------------------------------------------------------------------
:: Copyright (C) Nintendo Co., Ltd.  All rights reserved.
::
:: These coded instructions, statements, and computer programs contain
:: proprietary information of Nintendo of America Inc. and/or Nintendo
:: Company Ltd., and are protected by Federal copyright law.  They may
:: not be disclosed to third parties or copied or duplicated in any form,
:: in whole or in part, without the prior written consent of Nintendo.
:: ---------------------------------------------------------------------------

@echo off

setlocal

:: ---------------------------------------------------------------------------
:: Auto configurations.
:: ---------------------------------------------------------------------------
echo Auto configurations.

:: get domain name of e-mail address
echo Get domain name of e-mail address.

for /f "delims=@ tokens=2" %%a in ('git config user.email') do set "EMAIL_DOMAIN=%%a"

if not defined EMAIL_DOMAIN (
    echo WARNING: Could not find e-mail address. Please set your e-mail address to gitconfig.
    goto END
)

echo Your e-mail domain: %EMAIL_DOMAIN%

:: call subroutine.
call :CASE_%EMAIL_DOMAIN% 2>NUL

if not %ERRORLEVEL% == 0 (
    call :DEFAULT
)

goto END

:: ---------------------------------------------------------------------------
:: table
:: ---------------------------------------------------------------------------

:: ---------------------------------------------------------------------------
:CASE_nintendo.co.jp

    :: get prefix eg. PREFIX_user_name@nintendo.co.jp
    echo Get prefix of e-mail address.

    for /f "delims=_ tokens=1" %%a in ('git config user.email') do set "EMAIL_PREFIX=%%a"

    echo Your e-mail prefix: %EMAIL_PREFIX%

    call :CASE_%EMAIL_PREFIX%@nintendo.co.jp 2>NUL

    if not %ERRORLEVEL% == 0 (
        echo Setup attributes as 'InternalDevelopers'.
        git config exrepo-m.attributes "InternalDevelopers"
        set ERRORLEVEL=0
    )

    goto END

:: ---------------------------------------------------------------------------
:CASE_nintendo.com
:CASE_noa.nintendo.com

    echo Setup attributes as 'CoDevelopers'.
    git config exrepo-m.attributes "CoDevelopers"
    goto END

:: ---------------------------------------------------------------------------
:CASE_nerd.nintendo.com

    echo Setup attributes as 'NintendoDevelopers'.
    git config exrepo-m.attributes "NintendoDevelopers"
    goto END

:: ---------------------------------------------------------------------------
:CASE_ntd.nintendo.com

    :: get prefix eg. PREFIX.user_name@ntd.nintendo.com
    echo Get prefix of e-mail address.

    for /f "delims=. tokens=1" %%a in ('git config user.email') do set "EMAIL_PREFIX=%%a"

    echo Your e-mail prefix: %EMAIL_PREFIX%

    call :CASE_%EMAIL_PREFIX%@ntd.nintendo.com 2>NUL

    if not %ERRORLEVEL% == 0 (
        echo Setup attributes as 'NintendoDevelopers'.
        git config exrepo-m.attributes "NintendoDevelopers"
        set ERRORLEVEL=0
    )

    goto END

:: ---------------------------------------------------------------------------
:CASE_pux@nintendo.co.jp
:CASE_c@ntd.nintendo.com
:CASE_v@ntd.nintendo.com
:CASE_intsys.co.jp
:CASE_ndcube.co.jp 
:CASE_hallab.co.jp
:CASE_siliconstudio.co.jp
:CASE_esol.co.jp

    echo Setup attributes as 'CoDevelopers'.
    git config exrepo-m.attributes "CoDevelopers"
    goto END

:: ---------------------------------------------------------------------------
:DEFAULT

    echo WARNING: fail to auto configuration. '%EMAIL_DOMAIN%' is unkown domain. Please contact the repository administrator.
    echo Setup attributes as empty.
    git config exrepo-m.attributes ""
    goto END

:: ---------------------------------------------------------------------------

:END
