:: ---------------------------------------------------------------------------
:: Copyright (C)2014 Nintendo Co., Ltd.  All rights reserved.
::
:: These coded instructions, statements, and computer programs contain
:: proprietary information of Nintendo of America Inc. and/or Nintendo
:: Company Ltd., and are protected by Federal copyright law.  They may
:: not be disclosed to third parties or copied or duplicated in any form,
:: in whole or in part, without the prior written consent of Nintendo.
:: ---------------------------------------------------------------------------

::@echo off

setlocal

set SCRIPT_DIRECTORY=%~dp0
set REPOSITORY_ROOT=%~dp0\..\..\..\..\

:: ---------------------------------------------------------------------------
:: Get Variables
:: ---------------------------------------------------------------------------

call "%SCRIPT_DIRECTORY%getAtlassianVars.cmd"

set PAGEANT=pageant.exe
set PAGEANT_PATH=%SOURCETREE_DIRECTORY%tools\putty\%PAGEANT%

:: ---------------------------------------------------------------------------
:: Check conditions
:: ---------------------------------------------------------------------------

if not defined GIT_SSH (
    echo SKIP: GIT_SSH is not set.
    goto skip
)

if not exist "%GIT_SSH%" (
    echo SKIP: GIT_SSH is invalid.
    goto skip
)

tasklist /FI "IMAGENAME eq %PAGEANT%" | findstr %PAGEANT% > nul
if %ERRORLEVEL% == 0 (
    echo SKIP: pageant.exe is already active on system.
    goto skip
)

if not exist "%SOURCETREE_PUTTY_KEY%" (
    echo SKIP: Could not found SSH private keys.
    goto skip
)

:: ---------------------------------------------------------------------------
:: Start PuTTY agent
:: ---------------------------------------------------------------------------

start "pageant" "%PAGEANT_PATH%" "%SOURCETREE_PUTTY_KEY%"
echo Started PuTTY authentication agent automatically.
goto success

:error
exit /B 1

:skip
:success
