﻿Param(
    [string]$msiPath,
    [string]$skipUninstall
)

$scriptPath = $MYInvocation.MyCommand.Path
$scriptDir = Split-Path -Parent $scriptPath

function UninstallExistingTargetManager {
    $option = "//nologo `"$scriptDir/Uninstall-impl.js`""
    $exe = "cscript.exe"
    Write-Output "[UNINSTALL] existing Nintendo Target Manager."
    Write-Output "cscript.exe $option"
    # 終了コードは参照しないので、 Invoke-Expression で実行
    # (Start-Process だとうまく標準出力が Install.ps1 の出力として取得できないようだった)
    Invoke-Expression "$exe $option"
}

function InstallTargetManager ([string]$msiPath) {
    $exe = "msiexec.exe"
    $time = Get-Date -UFormat "%Y-%m-%d-%H%M%S"
    $logFileName = $env:TEMP + "/TargetManagerInstall_" + $time + ".log"
    $option = "/i `"$msiPath`" /l*v `"$logFileName`" /passive /promptrestart"
    Write-Output "$exe $option"
    $proc = Start-Process -FilePath $exe -ArgumentList $option -Wait -PassThru
    $exitCode = $proc.ExitCode
    Write-Output "=> $exitCode`r`n"
    return $exitCode
}

## VS の起動チェック
$vsRunningCheckerPath = "$scriptDir/../../Vsi/Scripts/check_vs_running.bat"
if (Test-Path $vsRunningCheckerPath) {
    & $vsRunningCheckerPath
    $ret = $LASTEXITCODE
    if ($ret -ne 0) {
        exit $ret
    }
}

if ($skipUninstall -ne "1") {
    UninstallExistingTargetManager
} else {
    Write-Output "[UNINSTALL] skip..."
}

Write-Output "`r`n"
Write-Output "[INSTALL] new Nintendo Target Manager. "
$result = InstallTargetManager($msiPath)
Write-Output $result[0]
Write-Output $result[1]
$ret = $result[-1]
exit $ret
