:: usage
:: > Install.bat                                // Install TargetManager (use current dir msi)
:: > Install.bat X:\PathTo\TargetManager.XXX.msi   // Install specified TargetManager
:: > Install.bat X:\PathTo\TargetManager.XXX.msi --checkenv  // Install specified TargetManager

@echo off
echo ===========================================================================
echo %0
echo ===========================================================================

setlocal

set WindowStyle=Normal
:: 第2引数で --checkenv を渡したとき (＝NDI のポストインストールハンドラから呼び出されるとき) だけ NINTENDOSDK_NOINSTALL_TARGET_MANAGER 環境変数をチェックする
if "%2"=="--checkenv" (
    echo [NINTENDOSDK_NOINSTALL_TARGET_MANAGER] ^(%NINTENDOSDK_NOINSTALL_TARGET_MANAGER%^)
    if "%NINTENDOSDK_NOINSTALL_TARGET_MANAGER%"=="TRUE" (
        goto :ExitWithDoNothing
    ) else if "%NINTENDOSDK_NOINSTALL_TARGET_MANAGER%"=="True" (
        goto :ExitWithDoNothing
    ) else if "%NINTENDOSDK_NOINSTALL_TARGET_MANAGER%"=="true" (
        goto :ExitWithDoNothing
    ) else if "%NINTENDOSDK_NOINSTALL_TARGET_MANAGER%"=="1" (
        goto :ExitWithDoNothing
    )
    set WindowStyle=Hidden
)

:: 第2引数で --wait を渡したときだけ pause で終了を待つ
set WaitAtEnd=0
if "%2"=="--wait" (
    set WaitAtEnd=1
)

set SkipUninstall=1
if not "%1"=="--skip" (
if not "%2"=="--skip" (
    set SkipUninstall=0
)
)

:: 第1引数で msi のパスを制定する
set MsiFilePath=%1
if "%MsiFilePath%"=="" (
    call :SetLatestMsiFilePath
)
if "%MsiFilePath%"=="" (
    echo Cannot find TargetManager.XXX.msi file @ %~dp0
    exit /b 1
)
echo [MsiFilePath] ^(%MsiFilePath%^)

:: ---- Install TargetManager.XXX.msi ---
powershell -ExecutionPolicy RemoteSigned "%~dp0Scripts\Install.ps1 -msiPath %MsiFilePath% -skipUninstall %SkipUninstall% -windowStyle %WindowStyle%;exit $LASTEXITCODE"
set RESULT=%ERRORLEVEL%
echo [RESULT] %RESULT%

if "%WaitAtEnd%"=="1" ( pause )
exit /b %RESULT%


:: -----------------------------------------------------------------------------
:SetLatestMsiFilePath
:: echo Search latest TargetManager.XXX.msi file...
for /F %%a in ('dir %~dp0*.msi /b /O-N') do (
    set MsiFilePath=%~dp0%%a
    goto BreakPoint
)
:BreakPoint
exit /b



:: -----------------------------------------------------------------------------
:ExitWithDoNothing
echo exit ^(do nothing^)
echo ... because NINTENDOSDK_NOINSTALL_TARGET_MANAGER is 1/TRUE/True/true
exit /b
