Dim root
root = WScript.Arguments(0)

Dim installerRoot
installerRoot = root + "\\Installers\\NvnDriver"

Dim osVersion
Dim osVersionString

Set wmi = GetObject("winmgmts:" & _
    "{impersonationLevel=impersonate}!\\.\root\cimv2")
Set osInfo = wmi.ExecQuery _
("Select * from Win32_OperatingSystem")
For Each objOperatingSystem In osInfo
    osVersionString = Left(objOperatingSystem.Version, 3)
Next

osVersion = CDbl(osVersionString)

Dim target
If osVersion >= 6.1 And osVersion <= 6.3 Then
    target = "win7-win8"
ElseIf osVersion >= 10.0 Then
    target = "win10"
Else
    WScript.StdErr.Write("Unexpected OS version. NvnDriver can run on Windows7, 8.1 or 10")
    WScript.Quit(1)
End If

Dim setup
setup = installerRoot + "\" + target + "\setup.exe"

Dim parameter
parameter = " -log:""" + installerRoot + "\" + target + "\InstallLogs"" -loglevel:6"

Set shell = WScript.CreateObject("WScript.Shell")
shell.Run(setup + parameter)
