﻿/*
 *  Copyright 2005-2014 Acer Cloud Technology, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of Acer Cloud Technology, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of Acer Cloud
 *  Technology, Inc.
 */

/*
 *               Copyright (C) 2010, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished proprietary information of BroadOn Communications Corp.,
 *  and are protected by federal copyright law. They may not be disclosed
 *  to third parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */


#ifndef __ESI_UTILS_H__
#define __ESI_UTILS_H__


#include <nn/escorei/esitypes.h>
#include <nn/iosc/iosc.h>
#include <nn/ioslibc/ioslibc.h>


#define ES_DEBUG_CRIT               1
#define ES_DEBUG_ERROR              2
#define ES_DEBUG_WARN               4
#define ES_DEBUG_INFO               8
#define ES_DEBUG_NOTIFY             16
#define ES_DEBUG_DEBUG              32
#define ES_DEBUG_TRACE              64

#define ES_DEBUG_LEVEL              0x7


#if !defined(GHV)
#define ES_DEBUG_LOG
#endif // !GHV

#if !defined(esLog)

#if defined(ES_DEBUG_LOG)

#define esLog(l, ...)                                           \
    do {                                                        \
        if ((l) & ES_DEBUG_LEVEL) {                             \
            printf("[ES] "__VA_ARGS__);                         \
        }                                                       \
    } while (0)

#else

#define esLog(l, ...)               (void)(0)

#endif  // defined(ES_DEBUG_LOG)

#endif  // !defined(esLog)


#endif  // __ESI_UTILS_H__
