﻿/*
 *  Copyright 2005-2014 Acer Cloud Technology, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of Acer Cloud Technology, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of Acer Cloud
 *  Technology, Inc.
 */

/*
 *  Copyright 2011 iGware Inc.
 *  All Rights Reserved.
 *
 *  THIS SOFTWARE CONTAINS CONFIDENTIAL INFORMATION AND
 *  TRADE SECRETS OF IGWARE INC.
 *  USE, DISCLOSURE OR REPRODUCTION IS PROHIBITED WITHOUT
 *  THE PRIOR EXPRESS WRITTEN PERMISSION OF IGWARE INC.
 *
 */

/*
 * C++ class definitions for publishing interfaces for V1 tickets and
 * titles with V1 TMDs.
 */

#ifndef __PUBLISH_H__
#define __PUBLISH_H__

#define PUBLISH_NAMESPACE_START  namespace bcc { namespace publish {
#define PUBLISH_NAMESPACE_END    } }
#define PUBLISH_NAMESPACE        bcc::publish
#define USING_PUBLISH_NAMESPACE  using namespace PUBLISH_NAMESPACE;
#define PUBLISH_SYM(sym)         PUBLISH_NAMESPACE::sym

#include <nn/nn_Macro.h>
#include <nn/escore/estypes.h>

PUBLISH_NAMESPACE_START

#define PUBLISH_HASHED_BLOCK_SIZE              (64*1024) /* 64 KB */
#define PUBLISH_HASHED_CLEAR_BLOCK_SIZE        (63*1024) /* 63 KB */

#define PUBLISH_HASHED_SUPERBLOCK_SIZE         (256*1024*1024) /* 256 MB */
#define PUBLISH_HASHED_CLEAR_SUPERBLOCK_SIZE   (252*1024*1024) /* 252 MB */

#define PUBLISH_HASHED_H3_SIZE                 20

USING_ES_NAMESPACE

class PublishTicket
{
    NN_DISALLOW_COPY(PublishTicket);

    public:
        // Initialization and shutdown
        PublishTicket(u8 *tikTemplate = NULL, u32 tikTemplateLen = 0);
        ~PublishTicket();

        // Start a new ticket without creating a new PublishTicket object
        ESError Reset(u8 *tikTemplate = NULL, u32 tikTemplateLen = 0);

        // Methods for filling in the ticket
        ESError SetTicketId(ESTicketId inTicketId);
        ESError SetTicketVersion(ESTicketVersion inTicketVersion);
        ESError SetRightsId(ESRightsId inRightsId);
        //
        // For personalized tickets, the device cert and device ID must
        // be specified.  Calling SetDeviceId is optional, since the deviceId
        // is also encoded in the common name in the device cert.
        //
        ESError SetDeviceCert(u8 *inDeviceCert, u32 inDeviceCertLen);
        ESError SetDeviceId(ESDeviceId inDeviceId);
        ESError SetLicenseType(ESLicenseType licenseType);
        ESError SetCommonKeyId(u8 commonKeyId);
        ESError SetPreInstallationFlag();
        ESError SetSharedTitleFlag();
        ESError SetAllContentsFlag();
        //
        // Use overloading to allow setting and unsetting these flags
        //
        ESError SetPreInstallationFlag(u8 preInstallationFlag);
        ESError SetSharedTitleFlag(u8 sharedTitleFlag);
        ESError SetAllContentsFlag(u8 allContentsFlag);

        //
        // SetContentMask can be used to activate the specified range of
        // content index values in the new ticket.
        //
        // This method can be used for any range of contents up to the
        // limit of 64K - 2 content indices (representing 64K - 1 contents).
        //
        // Note that content masks can also be set using the SetItemRights
        // call, but in that case the bit masks need to be constructed before
        // calling SetItemRights.  For a ticket with no other ItemRights, it
        // is more convenient to use SetContentMask.
        //
        ESError SetContentMask(u32 startIndex, u32 numContents);
        //
        // SetTitleKey takes the titleKey pre-encrypted with the CommonKey
        //
        ESError SetTitleKey(u8 *titleKey);
        //
        // If the titleKey is in cleartext, then the commonKey must be
        // supplied in order to perform the encryption in the PublishTicket class.
        //
        ESError SetTitleKeyClear(u8 *titleKey, u8 *commonKey);
        ESError SetReserved(u8 *reserved, u32 reservedLen);
        ESError SetAccountId(u32 accountId);
        //
        // For reattach signature
        ESError SetIssuer(const u8 *issuer);
        ESError SetSignData(const u8 *sign);
        //
        // This method must be invoked only once per ticket to specify all the
        // item rights for the ticket
        //
        ESError SetItemRights(ESItemRight *itemRights, u32 numItemRights);
        ESError SignTicket(const u8 *issuerName, u8 *rsaPubMod, u8 *rsaPrivExp);
        ESError PersonalizeTicket(u8 *privEccKey, u32 privEccKeyLen);
        ESError GetTicketLen(u32 *ticketLen);
        ESError OutputTicket(u8 *ticketBuf, u32 ticketBufLen);
        ESError DumpTicket();

        //
        // For the convenience of the publishing server code, provide access
        // to some of the ticket fields
        //
        ESError GetRightsId(ESRightsId *outRightsId);
        ESError GetTicketId(ESTicketId *outTicketId);
        ESError GetTicketVersion(ESTicketVersion *outTicketVersion);
        ESError GetTitleKey(u8 *outTitleKey);
        ESError GetDeviceId(ESDeviceId *outDeviceId);
        ESError GetCommonKeyId(u8 *outCommonKeyId);
        ESError GetAccountId(u32 *outAccountId);
        ESError GetPreInstallationFlag(u8 *preInstallationFlag);
        ESError GetSharedTitleFlag(u8 *sharedTitleFlag);
        ESError GetAllContentsFlag(u8 *allContentsFlag);
        ESError GetReserved(u8 *reserved, u32 *reservedLen);
        ESError GetIssuer(u8 *outIssuer);
        ESError GetSignData(u8 *outSign);
        ESError GetTicketDataForSign(u8 *outTicketBuf, u32 outTicketBufLen);
        ESError GetTicketDataForSignLen(u32 *outTicketLen);

    private:
        ESError Initialize(u8 *tikTemplate, u32 tikTemplateLen);
        void *privData;
};

PUBLISH_NAMESPACE_END

#endif  // __PUBLISH_H__
