﻿/*
 *  Copyright 2005-2014 Acer Cloud Technology, Inc.
 *  All Rights Reserved.
 *
 *  This software contains confidential information and
 *  trade secrets of Acer Cloud Technology, Inc.
 *  Use, disclosure or reproduction is prohibited without
 *  the prior express written permission of Acer Cloud
 *  Technology, Inc.
 */

/*
 *               Copyright (C) 2005, BroadOn Communications Corp.
 *
 *  These coded instructions, statements, and computer programs contain
 *  unpublished  proprietary information of BroadOn Communications Corp.,
 *  and  are protected by Federal copyright law. They may not be disclosed
 *  to  third  parties or copied or duplicated in any form, in whole or in
 *  part, without the prior written consent of BroadOn Communications Corp.
 *
 */

#ifndef _CSLSHA_H_
#define _CSLSHA_H_

#include <nn/csl/csltypes.h>
#include <nn/csl/aes_api.h>


typedef struct cslShaContext
{
    u32 intermediateHash[CSL_SHA1_DIGESTSIZE/4];
    u32 lengthLo;
    u32 lengthHi;
    u32 messageBlockIndex;
    u8 messageBlock[CSL_SHA1_BLOCKSIZE];
} CSL_ShaContext;

typedef struct cslHmacContext
{
    u8 keyExt[CSL_SHA1_BLOCKSIZE];
    CSL_ShaContext context;
} CSL_HmacContext;


typedef struct cslAesContext
{
    unsigned char iv[CSL_AES_BLOCKSIZE_BYTES];
    unsigned char key[CSL_AES_BLOCKSIZE_BYTES];
    AesKeyInstance keyInst;
    AesCipherInstance cipherInst;
}CSL_AesContext;

int CSL_ResetSha(CSL_ShaContext *context);
int CSL_InputSha(CSL_ShaContext *context, u8 *inputData, u32 inputSize);
int CSL_ResultSha(CSL_ShaContext *context, u8 cslShaHash[CSL_SHA1_DIGESTSIZE]);

int CSL_ResetHmac(CSL_HmacContext *context, CSLOSHMACKey key);
int CSL_InputHmac(CSL_HmacContext *context, u8 *inputData, u32 inputSize);
int CSL_ResultHmac(CSL_HmacContext *context,
                   u8 cslHmacHash[CSL_SHA1_DIGESTSIZE]);

int CSL_ResetEncryptAes(CSL_AesContext *context, CSLOSAesKey key,
                 CSLOSAesIv iv);
int CSL_ResetDecryptAes(CSL_AesContext *context, CSLOSAesKey key,
                 CSLOSAesIv iv);
int CSL_EncryptAes(CSL_AesContext *context, u8 *inputData, u32 size,
                   u8 *outputData);
int CSL_DecryptAes(CSL_AesContext *context, u8 *inputData, u32 size,
                   u8 *outputData);

#endif
