﻿// 文字コード:UTF-8
/// @file
#include <lib/logger/SimpleLoggerHandler.hpp>

#include <cstdio>
#include <lib/debug/Assert.hpp>
#include <lib/logger/LogLevelUtil.hpp>
#include <lib/Unused.hpp>

//------------------------------------------------------------------------------
namespace lib {
namespace logger {

//------------------------------------------------------------------------------
SimpleLoggerHandler& SimpleLoggerHandler::Instance()
{
    static SimpleLoggerHandler obj;
    return obj;
}

//------------------------------------------------------------------------------
void SimpleLoggerHandler::onLogWritten(
    const Logger& aLogger,
    const LogLevel::EnumType aLevel,
    const char* aMsg,
    const ILoggerHandler::TimeType aTime
    )
{
    LIB_UNUSED(aLogger);
    LIB_UNUSED(aMsg);
    LIB_UNUSED(aTime);

#if defined(LIB_OPT_USE_PRINTF)
    SYS_ASSERT(LogLevelUtil::IsValid(aLevel));

    if (aLevel == LogLevel::Debug) {
        // Debugなら、そのまま表示して終了
        SYS_LOG("%s", aMsg);
        return;
    }

    // ヘッダ表示
    {
        LIB_UNUSED(aTime);
        SYS_LOG(
            "[%s] ",
            LogLevelUtil::ToCString(aLevel)
            );
    }

    // メッセージ表示＆改行
    SYS_LOG("%s\n", aMsg);
#else
    LIB_UNUSED(aLevel);
    LIB_UNUSED(aMsg);
    LIB_UNUSED(aTime);
#endif
}

}} // namespace
// EOF
