﻿// 文字コード:UTF-8
/// @file
#pragma once

#include <lib/logger/LogLevel.hpp>

//------------------------------------------------------------------------------
namespace lib {
namespace logger {

/// @addtogroup LIB-Logger
//@{
/// LogLevelに関するユーティリティ関数群。
class LogLevelUtil
{
public:
    static bool IsValid(LogLevel::EnumType aLevel); ///< 有効な値か。
    static bool IsReceiveLog(
        LogLevel::EnumType aMessageLevel,
        LogLevel::EnumType aLoggerLevel
        ); ///< 受理されるログか。
    static const char* ToCString(LogLevel::EnumType aLevel); ///< 文字列として取得する。
};
//@}

}} // namespace
// EOF
