﻿// 文字コード:UTF-8
/// @file
#pragma once

namespace lib {

class StringUtil
    : NonCreatable
{
public:
    template <typename TChar>
    static void GetSubstringByLength(TChar* aDst, const TChar* aSrc, int aStartIdx, int aLen);
};

//------------------------------------------------------------------------------
template <typename TChar>
void StringUtil::GetSubstringByLength(TChar* aDst, const TChar* aSrc, int aStartIdx, int aLen)
{
    SYS_ASSERT_POINTER(aDst);
    SYS_ASSERT_POINTER(aSrc);
    SYS_ASSERT(0 <= aLen);
    ::std::memcpy(aDst, aSrc + aStartIdx, sizeof(TChar) * aLen);
    aDst[aLen] = 0;
}

} // namespace
// EOF
