﻿// 文字コード:UTF-8
/// @file
#pragma once

namespace lib {

// @note ::std::regex の生成にはそれなりに時間がかかるようなので、
//       多用する場合には利用側で保持して使いまわした方がパフォーマンスが出ます
class Regex
{
public:
    Regex();
    Regex(const char* aRegex);
    ~Regex();

    void reset(const char* aRegex);

    bool matchPartially(const char* aStr);

private:
    // @note <regex> のインクルードとともに <nn/os.h> や <WKC/WebKit/WKC/helpers/WKCString.h> など
    //       _LIBCPP_MUTEXのdefineが発生するファイルをインクルードしているとビルドエラーになる
    //       ひとまずPimplイディオムを利用して回避
    class RegexImpl;

    ::lib::ScopedPtr<RegexImpl> mImpl;
};

//------------------------------------------------------------------------------
} // namespace
// EOF
