﻿// 文字コード:UTF-8
/// @file

#include "lib/Regex.hpp"

#include <regex>

//------------------------------------------------------------------------------
namespace lib {

class Regex::RegexImpl
{
public:
    RegexImpl()
    : mRegex("")
    {
    }
    ~RegexImpl() {}

    void reset(const char* aRegex)
    {
        SYS_ASSERT(aRegex != nullptr);
        mRegex = ::std::regex(aRegex);
    }

    bool matchPartially(const char* aStr)
    {
        SYS_ASSERT(aStr != nullptr);

        ::std::match_results<const char*> results;
        return ::std::regex_search(aStr, results, mRegex);
    }

private:
    ::std::regex mRegex;
};

//------------------------------------------------------------------------------
Regex::Regex()
: mImpl()
{
    mImpl.reset(new RegexImpl());
}

//------------------------------------------------------------------------------
Regex::Regex(const char* aRegex)
: Regex()
{
    reset(aRegex);
}

//------------------------------------------------------------------------------
Regex::~Regex()
{
}

//------------------------------------------------------------------------------
void Regex::reset(const char* aRegex)
{
    mImpl->reset(aRegex);
}

//------------------------------------------------------------------------------
bool Regex::matchPartially(const char* aStr)
{
    return mImpl->matchPartially(aStr);
}

} // namespace
// EOF
