﻿// 文字コード:UTF-8
/// @file
#pragma once

LIB_FORWARD_DECLARE_2(lib, class Rect);

//------------------------------------------------------------------------------
namespace lib {

/// 矩形
/// ・最小位置とサイズで表わされる
/// ・最小位置以外を利用してしまうと期待挙動とならないメソッドがある点に注意
class IntRect
{
public:
    IntRect();
    IntRect(const ::lib::Vector2i& aPosition, const ::lib::Vector2i& aSize);
    IntRect(int aPosX, int aPosY, int aWidth, int aHeight);
    ::lib::Vector2i& position() { return mPosition; }
    const ::lib::Vector2i& position() const { return mPosition; }
    ::lib::Vector2i& size() { return mSize; }
    const ::lib::Vector2i& size() const { return mSize; }
    bool operator==(const IntRect& aRect) const;
    bool operator!=(const IntRect& aRect) const { return !operator==(aRect); }
    /// 設定する
    void set(const ::lib::Vector2i& aPosition, const ::lib::Vector2i& aSize);
    /// 「Rect」へ変換する
    Rect toRect() const;
    /// マンハッタン距離を取得する
    int getManhattanDistance(const IntRect& aRect) const;
    /// 矩形が空か？
    bool isEmpty() const;
    /// 面積を計算する
    int getArea() const;
    /// 位置が含まれるか？
    bool contains(const ::lib::Vector2i& aPos) const;
    /// 矩形が含まれるか？
    bool contains(const IntRect& aRect) const;
    /// 交差するか？
    bool intersects(const IntRect& aRect) const;
    /// 交差するか？(境界込み)
    bool intersectsWithBound(const IntRect& aRect) const;
    /// 交差させる(共通部分の矩形にする)
    void intersect(const IntRect& aRect);
    /// 交差させた結果を取得する
    IntRect getIntersected(const IntRect& aRect) const;
    /// 合体させる
    void unite(const IntRect& aRect);
    /// 合体させた結果を取得する
    IntRect getUnited(const IntRect& aRect) const;
    /// 範囲内に収める
    void clamp(const IntRect& aRect);
    /// 範囲内に収めた結果を取得する
    IntRect getClamped(const IntRect& aRect) const;
    /// 拡張する
    void inflate(int aLen);
    /// 拡張した結果を取得する
    IntRect getInflated(int aLen) const;
    /// 拡張する
    void inflate(const ::lib::Vector2i& aSize);
    /// 拡張した結果を取得する
    IntRect getInflated(const ::lib::Vector2i& aSize) const;
    /// 反対位置を取得する
    ::lib::Vector2i getOppositePosition() const;
    /// 中心位置を取得する
    ::lib::Vector2 getCenterPosition() const;
    /// 指定位置に最も近い矩形内の点を返す
    ::lib::Vector2i getNearestPosition(const ::lib::Vector2i& aPos) const;
    DEBUG_EVAL(String toString() const);
private:
    ::lib::Vector2i mPosition;
    ::lib::Vector2i mSize;
};
} // namespace
// EOF
