﻿// 文字コード:UTF-8
/// @file
#pragma once

#include <lib/Type.hpp>
#include <lib/ShortString.hpp>

namespace lib {
    struct Color4Pod;
}

//------------------------------------------------------------------------------
namespace lib {

/// @addtogroup LIB
//@{
/// 8bit符号無し整数をRGBAの順に並べた色構造体。
struct Color4bPod
{
public:
    /// @name 変数
    //@{
    uint8_t r; ///< Red。
    uint8_t g; ///< Green。
    uint8_t b; ///< Blue。
    uint8_t a; ///< Alpha。
    //@}

    /// @name 定数取得
    //@{
    static const Color4bPod Zero();     ///< 0の色。
    static const Color4bPod One();      ///< R,G,B,Aが全て255の色。
    static const Color4bPod UnitR();    ///< Rだけ255の色。
    static const Color4bPod UnitG();    ///< Gだけ255の色。
    static const Color4bPod UnitB();    ///< Bだけ255の色。
    static const Color4bPod UnitA();    ///< Aだけ255の色。
    static const Color4bPod Black();    ///< 黒色(0, 0, 0, 255)。
    static const Color4bPod White();    ///< 白色(255, 255, 255, 255)。
    //@}

    /// @name 変換
    //@{
    const Color4bPod toRRRR() const;     ///< R,G,B,Aを全てRの値に変換。
    const Color4bPod toGGGG() const;     ///< R,G,B,Aを全てGの値に変換。
    const Color4bPod toBBBB() const;     ///< R,G,B,Aを全てBの値に変換。
    const Color4bPod toAAAA() const;     ///< R,G,B,Aを全てAの値に変換。
    const Color4Pod  toRGBAf() const;    ///< float形式のColor4Podに変換。
    //@}

    /// @name ユーティリティ
    //@{
    /// "R,G,B,A"形式の文字列に変換。
    const ::lib::ShortString toShortString() const;
    //@}
};
//@}

} // namespace
// EOF
