﻿// 文字コード:UTF-8
/// @file
#include "SplitCommandUnitTest.hpp"

#include "SplitCommand.hpp"

//------------------------------------------------------------------------------
void SplitCommandUnitTest::UnitTest()
{
    // WebAppletが利用できる引数が取得できるか
    {
        const char* args[] = {
            "null",
            "web", "http://www.nintendo.com",
            "--boot-as-media-player", "true",
            "--media-player-auto-close-enabled", "true",
            "--callback-url", "http://www.nintendo.com/callback",
            "--callbackable-url", "http://www.nintendo.com/callbackable",
            "--pointer-enabled", "true",
            "--left-stick-mode", "SpatialNavi",
            "--user-index", "1",
            "--background-kind", "ApplicationCapture",
            "--boot-display-kind", "Default",
            "--js-extension-enabled", "true",
            "--display-url-kind", "Domain",
            "--user-agent-additional-string", "TestAgent/1.0",
            "--touch-enabled-on-contents", "false",
            "--page-cache-enabled", "false",
            "--footer-fixed-kind", "Shown",
            "--page-fade-enabled", "false",
            "--page-scroll-indicator-enabled", "true",
            "--media-player-speed-control-enabled", "true",
            "--help",
        };
        auto count = sizeof(args) / sizeof(args[0]);
        SplitCommand splitCmd(count, reinterpret_cast<char**>(&args));
        SYS_ASSERT(splitCmd.hasKey("web"));
        SYS_ASSERT(std::strcmp(splitCmd.getString("web"), "http://www.nintendo.com") == 0);
        SYS_ASSERT(splitCmd.hasKey("--boot-as-media-player"));
        SYS_ASSERT(splitCmd.hasKey("--media-player-auto-close-enabled"));
        SYS_ASSERT(splitCmd.hasKey("--callback-url"));
        SYS_ASSERT(std::strcmp(splitCmd.getString("--callback-url"), "http://www.nintendo.com/callback") == 0);
        SYS_ASSERT(splitCmd.hasKey("--callbackable-url"));
        SYS_ASSERT(std::strcmp(splitCmd.getString("--callbackable-url"), "http://www.nintendo.com/callbackable") == 0);
        SYS_ASSERT(splitCmd.hasKey("--pointer-enabled"));
        SYS_ASSERT(splitCmd.hasKey("--left-stick-mode"));
        SYS_ASSERT(std::strcmp(splitCmd.getString("--left-stick-mode"), "SpatialNavi") == 0);
        SYS_ASSERT(splitCmd.hasKey("--user-index"));
        SYS_ASSERT(splitCmd.getInt("--user-index") == 1);
        SYS_ASSERT(splitCmd.hasKey("--background-kind"));
        SYS_ASSERT(std::strcmp(splitCmd.getString("--background-kind"), "ApplicationCapture") == 0);
        SYS_ASSERT(splitCmd.hasKey("--boot-display-kind"));
        SYS_ASSERT(std::strcmp(splitCmd.getString("--boot-display-kind"), "Default") == 0);
        SYS_ASSERT(splitCmd.hasKey("--js-extension-enabled"));
        SYS_ASSERT(splitCmd.hasKey("--display-url-kind"));
        SYS_ASSERT(std::strcmp(splitCmd.getString("--display-url-kind"), "Domain") == 0);
        SYS_ASSERT(std::strcmp(splitCmd.getString("--user-agent-additional-string"), "TestAgent/1.0") == 0);
        SYS_ASSERT(splitCmd.hasKey("--touch-enabled-on-contents"));
        SYS_ASSERT(std::strcmp(splitCmd.getString("--touch-enabled-on-contents"), "false") == 0);
        SYS_ASSERT(std::strcmp(splitCmd.getString("--page-cache-enabled"), "false") == 0);
        SYS_ASSERT(std::strcmp(splitCmd.getString("--footer-fixed-kind"), "Shown") == 0);
        SYS_ASSERT(std::strcmp(splitCmd.getString("--page-fade-enabled"), "false") == 0);
        SYS_ASSERT(std::strcmp(splitCmd.getString("--page-scroll-indicator-enabled"), "true") == 0);
        SYS_ASSERT(std::strcmp(splitCmd.getString("--media-player-speed-control-enabled"), "true") == 0);
        SYS_ASSERT(splitCmd.hasKey("--help"));
    }

    // OfflineAppletが利用できる引数が取得できるか
    {
        const char* args[] = {
            "null",
            "offline", "debug://sample.htdocs/index.html",
            "--boot-as-media-player", "true",
            "--media-player-auto-close-enabled", "true",
            "--pointer-enabled", "true",
            "--left-stick-mode", "StickPointer",
            "--footer-enabled", "false",
            "--background-kind", "ApplicationCaptureBlur",
            "--boot-display-kind", "Black",
            "--key-repeat-delay-frame", "5",
            "--key-repeat-pulse-frame", "3",
            "--js-extension-enabled", "true",
            "--touch-enabled-on-contents", "false",
            "--page-cache-enabled", "false",
            "--footer-fixed-kind", "Shown",
            "--page-fade-enabled", "false",
            "--boot-loading-icon-enabled", "false",
            "--page-scroll-indicator-enabled", "true",
            "--media-player-speed-control-enabled", "true",
            "--help",
        };
        auto count = sizeof(args) / sizeof(args[0]);
        SplitCommand splitCmd(count, reinterpret_cast<char**>(&args));
        SYS_ASSERT(splitCmd.hasKey("offline"));
        SYS_ASSERT(std::strcmp(splitCmd.getString("offline"), "debug://sample.htdocs/index.html") == 0);
        SYS_ASSERT(splitCmd.hasKey("--boot-as-media-player"));
        SYS_ASSERT(splitCmd.hasKey("--media-player-auto-close-enabled"));
        SYS_ASSERT(splitCmd.hasKey("--pointer-enabled"));
        SYS_ASSERT(splitCmd.hasKey("--left-stick-mode"));
        SYS_ASSERT(std::strcmp(splitCmd.getString("--left-stick-mode"), "StickPointer") == 0);
        SYS_ASSERT(splitCmd.hasKey("--footer-enabled"));
        SYS_ASSERT(std::strcmp(splitCmd.getString("--footer-enabled"), "false") == 0);
        SYS_ASSERT(splitCmd.hasKey("--background-kind"));
        SYS_ASSERT(std::strcmp(splitCmd.getString("--background-kind"), "ApplicationCaptureBlur") == 0);
        SYS_ASSERT(splitCmd.hasKey("--boot-display-kind"));
        SYS_ASSERT(std::strcmp(splitCmd.getString("--boot-display-kind"), "Black") == 0);
        SYS_ASSERT(splitCmd.hasKey("--key-repeat-delay-frame"));
        SYS_ASSERT(splitCmd.getInt("--key-repeat-delay-frame") == 5);
        SYS_ASSERT(splitCmd.hasKey("--key-repeat-pulse-frame"));
        SYS_ASSERT(splitCmd.getInt("--key-repeat-pulse-frame") == 3);
        SYS_ASSERT(splitCmd.hasKey("--js-extension-enabled"));
        SYS_ASSERT(splitCmd.hasKey("--touch-enabled-on-contents"));
        SYS_ASSERT(std::strcmp(splitCmd.getString("--touch-enabled-on-contents"), "false") == 0);
        SYS_ASSERT(std::strcmp(splitCmd.getString("--page-cache-enabled"), "false") == 0);
        SYS_ASSERT(std::strcmp(splitCmd.getString("--footer-fixed-kind"), "Shown") == 0);
        SYS_ASSERT(std::strcmp(splitCmd.getString("--page-fade-enabled"), "false") == 0);
        SYS_ASSERT(std::strcmp(splitCmd.getString("--boot-loading-icon-enabled"), "false") == 0);
        SYS_ASSERT(std::strcmp(splitCmd.getString("--page-scroll-indicator-enabled"), "true") == 0);
        SYS_ASSERT(std::strcmp(splitCmd.getString("--media-player-speed-control-enabled"), "true") == 0);
        SYS_ASSERT(splitCmd.hasKey("--help"));
    }

    // 無効な引数のみなら無効となるか
    {
        const char* args[] = {
            "null",
            "hoge",
            "foo",
        };
        auto count = sizeof(args) / sizeof(args[0]);
        SplitCommand splitCmd(count, reinterpret_cast<char**>(&args));
        SYS_ASSERT(!splitCmd.isValid());
    }

    // 未完成の引数を無視できるか
    {
        const char* args[] = {
            "null",
            "web", "http://www.nintendo.com",
            "--user-index",
        };
        auto count = sizeof(args) / sizeof(args[0]);
        SplitCommand splitCmd(count, reinterpret_cast<char**>(&args));
        SYS_ASSERT(!splitCmd.hasKey("uid"));
    }

    // web --help が問題ないか
    {
        const char* args[] = {
            "null",
            "web",
            "--help",
        };
        auto count = sizeof(args) / sizeof(args[0]);
        SplitCommand splitCmd(count, reinterpret_cast<char**>(&args));
        SYS_ASSERT(splitCmd.hasKey("web"));
        SYS_ASSERT(splitCmd.hasKey("--help"));
    }

    // offline --help が問題ないか
    {
        const char* args[] = {
            "null",
            "offline",
            "--help",
        };
        auto count = sizeof(args) / sizeof(args[0]);
        SplitCommand splitCmd(count, reinterpret_cast<char**>(&args));
        SYS_ASSERT(splitCmd.hasKey("offline"));
        SYS_ASSERT(splitCmd.hasKey("--help"));
    }


}

//------------------------------------------------------------------------------
// EOF
