﻿
/*-
* Copyright (c) 1982, 1986, 1989, 1993
*      The Regents of the University of California.  All rights reserved.
* (c) UNIX System Laboratories, Inc.
* All or some portions of this file are derived from material licensed
* to the University of California by American Telephone and Telegraph
* Co. or Unix System Laboratories, Inc. and are reproduced herein with
* the permission of UNIX System Laboratories, Inc.
*
* Redistribution and use in source and binary forms, with or without
* modification, are permitted provided that the following conditions
* are met:
* 1. Redistributions of source code must retain the above copyright
*    notice, this list of conditions and the following disclaimer.
* 2. Redistributions in binary form must reproduce the above copyright
*    notice, this list of conditions and the following disclaimer in the
*    documentation and/or other materials provided with the distribution.
* 4. Neither the name of the University nor the names of its contributors
*    may be used to endorse or promote products derived from this software
*    without specific prior written permission.
*
* THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
* ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
* IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
* ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
* FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
* DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
* OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
* HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
* LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
* OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
* SUCH DAMAGE.
*
*      @(#)param.h     8.3 (Berkeley) 4/4/95
* $FreeBSD$
*/

#ifndef _SYS_BSDPARAM_H_
#define _SYS_BSDPARAM_H_

#include <sys/types.h>
#include <sys/errno.h>
#include <sys/priority.h>
#include <siglo/siglo.h>
#include <machine/param.h>

#ifndef MAXPHYS
#define MAXPHYS		(128 * 1024)	/* max raw I/O transfer size */
#endif
/*
 * Constants related to network buffer management.
 * MCLBYTES must be no larger than PAGE_SIZE.
 */
#ifndef MSIZE
#define MSIZE           256             /* size of an mbuf */
#endif

#ifndef MCLSHIFT
#define MCLSHIFT        11              /* convert bytes to mbuf clusters */
#endif  /* MCLSHIFT */

#define MCLBYTES        (1 << MCLSHIFT) /* size of an mbuf cluster */

#if PAGE_SIZE < 2048
#define MJUMPAGESIZE    MCLBYTES
#elif PAGE_SIZE <= 8192
#define MJUMPAGESIZE    PAGE_SIZE
#else
#define MJUMPAGESIZE    (8 * 1024)
#endif

#define MJUM9BYTES      (9 * 1024)      /* jumbo cluster 9k */
#define MJUM16BYTES     (16 * 1024)     /* jumbo cluster 16k */

#ifndef PATH_MAX
#define PATH_MAX        1024            /* max bytes in pathname */
#endif

#ifndef MAXPATHLEN
#define MAXPATHLEN      PATH_MAX
#endif

#ifndef MAXHOSTNAMELEN
#define MAXHOSTNAMELEN  256             /* max hostname size */
#endif

#ifndef SPECNAMELEN
#define SPECNAMELEN     63
#endif

#ifndef MAXCOMLEN
#define MAXCOMLEN       19              /* max command name remembered */
#endif

#ifndef roundup
#define	roundup(x, y)	((((x)+((y)-1))/(y))*(y))  /* to any y */
#endif

#ifndef powerof2
#define powerof2(x)	    ((((x)-1)&(x))==0)
#endif

#ifndef MIN
#define MIN(a,b)        (((a)<(b))?(a):(b))
#endif

#ifndef MAX
#define MAX(a,b)        (((a)>(b))?(a):(b))
#endif

#ifndef NBBY
#define NBBY 8
#endif

#ifndef howmany
#define howmany(n,d) (((n)+((d)-1))/(d))
#endif

#undef  __FreeBSD_version
#define __FreeBSD_version 1001505       /* Master, propagated to newvers */

#define	roundup2(x, y)	(((x)+((y)-1))&(~((y)-1))) /* if y is powers of two */

#define PRIMASK 0x0ff
#define PCATCH  0x100   /* OR'd with pri for tsleep to check signals */
#define PDROP   0x200   /* OR'd with pri to stop re-entry of interlock mutex */

#ifdef _KERNEL
#include <sys/cdefs.h>

/*
 * Basic byte order function prototypes for non-inline functions.
 */
#ifndef LOCORE
#ifndef _BYTEORDER_PROTOTYPED
#define _BYTEORDER_PROTOTYPED
__BEGIN_DECLS
uint32_t       htonl(uint32_t);
uint16_t       htons(uint16_t);
uint32_t       ntohl(uint32_t);
uint16_t       ntohs(uint16_t);
__END_DECLS
#endif
#endif

#ifndef lint
#ifndef _BYTEORDER_FUNC_DEFINED
#define _BYTEORDER_FUNC_DEFINED
#define htonl(x)        __htonl(x)
#define htons(x)        __htons(x)
#define ntohl(x)        __ntohl(x)
#define ntohs(x)        __ntohs(x)
#endif /* !_BYTEORDER_FUNC_DEFINED */
#endif /* lint */
#endif /* _KERNEL */

#endif
