﻿/*-
 * Copyright (c) 1986, 1993
 *	The Regents of the University of California.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *	@(#)if_arp.h	8.1 (Berkeley) 6/10/93
 * $FreeBSD$
 */

#ifndef _NET_IF_ARP_H_
#define	_NET_IF_ARP_H_

#include_next <net/if_arp.h>

#ifdef _KERNEL
/*
 * Structure shared between the ethernet driver modules and
 * the address resolution code.
 */
struct	arpcom {
    struct 	ifnet *ac_ifp;		/* network-visible interface */
    void	*ac_netgraph;		/* ng_ether(4) netgraph node info */
};
#define IFP2AC(ifp) ((struct arpcom *)(ifp->if_l2com))
#define AC2IFP(ac) ((ac)->ac_ifp)

#include <sys/counter.h>
#include <net/vnet.h>

VNET_PCPUSTAT_DECLARE(struct arpstat, arpstat);
/*
 * In-kernel consumers can use these accessor macros directly to update
 * stats.
 */
#define	ARPSTAT_ADD(name, val)	\
    VNET_PCPUSTAT_ADD(struct arpstat, arpstat, name, (val))
#define	ARPSTAT_SUB(name, val)	ARPSTAT_ADD(name, -(val))
#define	ARPSTAT_INC(name)	ARPSTAT_ADD(name, 1)
#define	ARPSTAT_DEC(name)	ARPSTAT_SUB(name, 1)

#endif /* _KERNEL */

#endif /* !_NET_IF_ARP_H_ */
