#!/bin/bash

#-------------------------------------------------------------------------------
#  This runs the script that generates the "!.nact--external", then creates a
#  "LibcTest" folder in "SDK/Samples/Sources/Applications" and copies
#  "!.nact--external" to it, then edits "Samples/Sources/Applications/!.nact"
#  to add "build LibcTest" if needed.
#
#  This script assumes that the 'SIGLO_ROOT' variable is set. It's the path to
#  the SDK root directory, which is where the "NintendoSdkRootMark" file is.
#-------------------------------------------------------------------------------

# Make sure the output directories exist
if [ -z "$NINTENDO_SDK_ROOT" ]
then
    echo " -- ERROR -- Need to set NINTENDO_SDK_ROOT to the root of your SDK directory"
    exit 1
elif [ ! -d "$NINTENDO_SDK_ROOT" ]
then
    echo " -- ERROR -- 'NINTENDO_SDK_ROOT' is not set correctly. Directory doesn't exist: ${NINTENDO_SDK_ROOT}"
    exit 1
fi

output_dir_tests=${NINTENDO_SDK_ROOT}/Tests/Sources/Tests/LibcTests/TlsTests
if [ -d "${output_dir_tests}-if-this-directory-exists-delete-it-when-restore" ]
then
    if [ -d "$output_dir_tests" ]
    then
        rm -r "${output_dir_tests}"
    fi
    if [ -d "${output_dir_tests}--backup" ]
    then
        rm -r "${output_dir_tests}--backup"
    fi
    rm -r "${output_dir_tests}-if-this-directory-exists-delete-it-when-restore"
    rm ${NINTENDO_SDK_ROOT}/Tests/Sources/Tests/LibcTests/!.nact
    mv "${NINTENDO_SDK_ROOT}/Tests/Sources/Tests/LibcTests/!.nact--backup" "${NINTENDO_SDK_ROOT}/Tests/Sources/Tests/LibcTests/!.nact"
else
    if [ -d "$output_dir_tests" ]
    then
        rm -r "${output_dir_tests}"
    fi

    if [ -d "${output_dir_tests}--backup" ]
    then
        mv "${output_dir_tests}--backup" ${output_dir_tests}
    fi
fi

output_dir_externals=${NINTENDO_SDK_ROOT}/Externals/Tests/TlsTests
if [ -d "${output_dir_externals}-if-this-directory-exists-delete-it-when-restore" ]
then
    if [ -d "$output_dir_externals" ]
    then
        rm -r "${output_dir_externals}"
    fi
    if [ -d "${output_dir_externals}--backup" ]
    then
        rm -r "${output_dir_externals}--backup"
    fi
    rm -r "${output_dir_externals}-if-this-directory-exists-delete-it-when-restore"
else
    if [ -d "$output_dir_externals" ]
    then
        rm -r "${output_dir_externals}"
    fi

    if [ -d "${output_dir_externals}--backup" ]
    then
        mv "${output_dir_externals}--backup" ${output_dir_externals}
    fi
fi

integrate_testlist=${NINTENDO_SDK_ROOT}/Integrate/Scripts/Testlist
if [ -e "${integrate_testlist}/RyndaTlsTests.NX.testlist-if-this-file-exists-delete-it-when-restore.yml" ]
then
    if [ -e "${integrate_testlist}/RyndaTlsTests.NX.testlist.yml" ]
    then
        rm "${integrate_testlist}/RyndaTlsTests.NX.testlist.yml"
    fi
    if [ -e "${integrate_testlist}/RyndaTlsTests.NX.testlist.yml--backup" ]
    then
        rm "${integrate_testlist}/RyndaTlsTests.NX.testlist.yml--backup"
    fi
    rm "${integrate_testlist}/RyndaTlsTests.NX.testlist-if-this-file-exists-delete-it-when-restore.yml"
else
    if [ -e "${integrate_testlist}/RyndaTlsTests.NX.testlist.yml" ]
    then
        rm "${integrate_testlist}/RyndaTlsTests.NX.testlist.yml"
    fi

    if [ -e "${integrate_testlist}/RyndaTlsTests.NX.testlist.yml--backup" ]
    then
        mv "${integrate_testlist}/RyndaTlsTests.NX.testlist.yml--backup" "${integrate_testlist}/RyndaTlsTests.NX.testlist.yml"
    fi
fi

