﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <cstdint>
#include <cstddef>
#include <cstdlib>
#include <pthread.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/os.h>
#include <nn/svc/svc_ThreadLocalRegion.h>
#include <climits>
#include <nn/os/os_ThreadApi.h>
#include "ntd-test-tls.h"

#define MIN_ALIGN nn::os::ThreadStackAlignment

extern void *__dso_handle;  // this is defined in Chris/Sources/Libraries/rocrt/rocrt.cpp

#define STACK_SIZE (3 * MIN_ALIGN)

const size_t            ThreadStackSize = STACK_SIZE;                 // スレッド操作スレッドのスタックサイズ
NN_OS_ALIGNAS_THREAD_STACK char  g_ThreadStack1[ ThreadStackSize ];   // 1つ目のスレッドのスタック
NN_OS_ALIGNAS_THREAD_STACK char  g_ThreadStack2[ ThreadStackSize ];   // 2つ目のスレッドのスタック

nn::os::ThreadType      g_Thread1;
nn::os::ThreadType      g_Thread2;

int                     GameMinus;
thread_local short      GamePlus;
thread_local char       GamePlus1 = 1;
thread_local int        GamePlus100 = 100;
thread_local double     GamePlusDouble = 2.0;
thread_local float      GamePlusFloat;

#define TEST_ROOT_NAME STRINGIZE_VALUE_OF(TLS_TEST_NAME)
#if ULONG_MAX == 0xffffffff
#define TEST_NAME "ARM32-" TEST_ROOT_NAME
#else
#define TEST_NAME "AARCH64-" TEST_ROOT_NAME
#endif

int counter = 0;
class Hoge
{
public:
    int x;
    int id;
    nn::os::ThreadType *Hoge_thread;
    char *name = (char *)"<unitialized name>";
    Hoge() {
        id = ++counter;
        Hoge_thread = nn::os::GetCurrentThread();
        TESTLOG("Hello from class Hoge (%s) %d thread address 0x%08zX; id = %d", name, x, (size_t)Hoge_thread, id);
    }
    Hoge(char *func_name, int T) {
        x = T;
        id = ++counter;
        name = func_name;
        Hoge_thread = nn::os::GetCurrentThread();
        TESTLOG("Hello from class Hoge (%s) %d thread address 0x%08zX; id = %d", name, x, (size_t)Hoge_thread, id);
    }
    ~Hoge() {
        TESTLOG("Good-bye from class Hoge (%s) %d thread address 0x%08zX; id = %d!", name, x, (size_t)Hoge_thread, id);
    }
};
class Hoge1
{
public:
    int x;
    nn::os::ThreadType *Hoge1_thread;
    char *name = (char *)"<unitialized name>";
    Hoge1() {
        Hoge1_thread = nn::os::GetCurrentThread();
        TESTLOG("Hello from class Hoge1 (%s) %d thread address 0x%08zX", name, x, (size_t)Hoge1_thread);
    }
    Hoge1(char *func_name, int T) {
        x = T;
        name = func_name;
        Hoge1_thread = nn::os::GetCurrentThread();
        TESTLOG("Hello from class Hoge1 (%s) %d thread address 0x%08zX", name, x, (size_t)Hoge1_thread);
    }
    ~Hoge1() {
        TESTLOG("Good-bye from class Hoge1 (%s) %d thread address 0x%08zX!", name, x, (size_t)Hoge1_thread);
    }
};
class Hoge2
{
public:
    int x;
    nn::os::ThreadType *Hoge2_thread;
    char *name = (char *)"<unitialized name>";
    Hoge2() {
        Hoge2_thread = nn::os::GetCurrentThread();
        TESTLOG("Hello from class Hoge2 (%s) %d thread address 0x%08zX", name, x, (size_t)Hoge2_thread);
    }
    Hoge2(char *func_name, int T) {
        x = T;
        name = func_name;
        Hoge2_thread = nn::os::GetCurrentThread();
        TESTLOG("Hello from class Hoge2 (%s) %d thread address 0x%08zX", name, x, (size_t)Hoge2_thread);
    }
    ~Hoge2() {
        TESTLOG("Good-bye from class Hoge2 (%s) %d thread address 0x%08zX!", name, x, (size_t)Hoge2_thread);
    }
};
class Hoge3
{
public:
    int x;
    nn::os::ThreadType *Hoge3_thread;
    char *name = (char *)"<unitialized name>";
    Hoge3() {
        Hoge3_thread = nn::os::GetCurrentThread();
        TESTLOG("Hello from class Hoge3 (%s) %d thread address 0x%08zX", name, x, (size_t)Hoge3_thread);
    }
    Hoge3(char *func_name, int T) {
        x = T;
        name = func_name;
        Hoge3_thread = nn::os::GetCurrentThread();
        TESTLOG("Hello from class Hoge3 (%s) %d thread address 0x%08zX", name, x, (size_t)Hoge3_thread);
    }
    ~Hoge3() {
        TESTLOG("Good-bye from class Hoge3 (%s) %d thread address 0x%08zX!", name, x, (size_t)Hoge3_thread);
    }
};
class Hoge4
{
public:
    int x;
    nn::os::ThreadType *Hoge4_thread;
    char *name = (char *)"<unitialized name>";
    Hoge4() {
        Hoge4_thread = nn::os::GetCurrentThread();
        TESTLOG("Hello from class Hoge4 (%s) %d thread address 0x%08zX", name, x, (size_t)Hoge4_thread);
    }
    Hoge4(char *func_name, int T) {
        x = T;
        name = func_name;
        Hoge4_thread = nn::os::GetCurrentThread();
        TESTLOG("Hello from class Hoge4 (%s) %d thread address 0x%08zX", name, x, (size_t)Hoge4_thread);
    }
    ~Hoge4() {
        TESTLOG("Good-bye from class Hoge4 (%s) %d thread address 0x%08zX!", name, x, (size_t)Hoge4_thread);
    }
};
thread_local Hoge g_Hoge0((char *)"g_Hoge0", 45);
thread_local Hoge g_Hoge0_0((char *)"g_Hoge0_0", 50);
//thread_local Hoge g_Hoge_unused;
//thread_local Hoge g_Hoge1 = Hoge((char *)"g_Hoge1", -1);
//thread_local Hoge g_Hoge2 = Hoge((char *)"g_Hoge2", -2);
//thread_local Hoge g_Hoge3 = Hoge((char *)"g_Hoge3", -3);
//thread_local Hoge g_Hoge4 = Hoge((char *)"g_Hoge4", -4);

static void call_constructor(int a)
{
    TESTLOG("Entering call_constructor");
    nn::os::ThreadType *cur_thread = nn::os::GetCurrentThread();
    TESTLOG("cur_thread = 0x%08zX", (size_t)cur_thread);
    TESTLOG("Exiting call_constructor");
}

static void GameUpdatePlusMinus()
{
    GameMinus -= 5;;
    GamePlus += 5;
    GamePlus1 += 1;
    GamePlus100 += 100;
    GamePlusDouble += 5.0;
    GamePlusFloat -= 5.0;
}

/*---------------------------------------------------------------------------*
  Name:         TestThread

  Description:  This is the main function of the thread.
                It displays the resulting values of each variable.

  Arguments:    1 or 2.

  Returns:      Always zero

 *---------------------------------------------------------------------------*/

static void TestThread(void *arg)
{
    int i;
    long num_dtrs_to_call_start, num_dtrs_to_call_end;
    num_dtrs_to_call_start = __nnmusl_get_tls_dtors_status (__dso_handle);
    TESTLOG("There are %ld registered destructors at the beginning of TestThread %p.", num_dtrs_to_call_start, arg);
#if ENABLE_TLS_INT
    #if ENABLE_MY_INT
        TESTCASE_MESSAGE((num_dtrs_to_call_start >= 3) && (num_dtrs_to_call_start <= 5), "num_dtrs_to_call_start %ld", num_dtrs_to_call_start);
    #else
        TESTCASE_MESSAGE((num_dtrs_to_call_start >= 1) && (num_dtrs_to_call_start <= 3), "num_dtrs_to_call_start %ld", num_dtrs_to_call_start);
    #endif
#else
    #if ENABLE_MY_INT
        TESTCASE_MESSAGE((num_dtrs_to_call_start >= 2) && (num_dtrs_to_call_start <= 4), "num_dtrs_to_call_start %ld", num_dtrs_to_call_start);
    #else
        TESTCASE_MESSAGE((num_dtrs_to_call_start >= 0) && (num_dtrs_to_call_start <= 2), "num_dtrs_to_call_start %ld", num_dtrs_to_call_start);
    #endif
#endif

    TESTCASE_MESSAGE(GamePlus == 0, "GamePlus when initialized: %d (expected 0)", GamePlus);
    TESTCASE_MESSAGE(GamePlus1 == 1, "GamePlus1 when initialized: %d (expected 1)", GamePlus1);
    TESTCASE_MESSAGE(GamePlus100 == 100, "GamePlus100 when initialized: %d (expected 100)", GamePlus100);
    TESTCASE_MESSAGE(GamePlusDouble == 2.0, "GamePlusDouble when initialized: %d (expected 2.0)", GamePlusDouble);
    TESTCASE_MESSAGE(GamePlusFloat == 0.0, "GamePlusFloat when initialized: %f (expected 0.0)", GamePlusFloat);

    for (i = 0; i < 5; i++)
    {
        TESTLOG("Hello! from TestThread %p.", arg);
        // normal global data
        GameMinus--;
        // thread local storage data
        GamePlus++;
        GamePlus100++;
        GameUpdatePlusMinus();
    }
    TESTCASE_MESSAGE(GamePlus == 30, "GamePlus at thread exit: %d (expected 30)", GamePlus);
    TESTCASE_MESSAGE(GamePlus1 == 6, "GamePlus1 at thread exit: %d (expected 6)", GamePlus1);
    TESTCASE_MESSAGE(GamePlus100 == 605, "GamePlus100 at thread exit: %d (expected 605)", GamePlus100);
    TESTCASE_MESSAGE(GamePlusDouble == 27.0, "GamePlusDouble at thread exit: %f (expected 27.0)", GamePlusDouble);
    TESTCASE_MESSAGE(GamePlusFloat == -25.0, "GamePlusFloat at thread exit: %f (expected -25.0)", GamePlusFloat);

    num_dtrs_to_call_end = __nnmusl_get_tls_dtors_status (__dso_handle);
    TESTLOG("There are %ld registered destructors at the end of TestThread %p.", num_dtrs_to_call_end, arg);
#if ENABLE_TLS_INT
    #if ENABLE_MY_INT
        TESTCASE_MESSAGE((num_dtrs_to_call_end >= 5) && (num_dtrs_to_call_end <= 7), "num_dtrs_to_call_end %ld", num_dtrs_to_call_end);
    #else
        TESTCASE_MESSAGE((num_dtrs_to_call_end >= 3) && (num_dtrs_to_call_end <= 5), "num_dtrs_to_call_end %ld", num_dtrs_to_call_end);
    #endif
#else
    #if ENABLE_MY_INT
        TESTCASE_MESSAGE((num_dtrs_to_call_end >= 4) && (num_dtrs_to_call_end <= 6), "num_dtrs_to_call_end %ld", num_dtrs_to_call_end);
    #else
        TESTCASE_MESSAGE((num_dtrs_to_call_end >= 2) && (num_dtrs_to_call_end <= 4), "num_dtrs_to_call_end %ld", num_dtrs_to_call_end);
    #endif
#endif
}

/*---------------------------------------------------------------------------*
  Name:         main

  Description:  This is the main function of the demo.

                This demo displays Hello! on the main thread and sub-threads.

  Arguments:    None.

  Returns:      Always zero.

 *---------------------------------------------------------------------------*/
extern void tls_horizon_2nd_file(void);
thread_local int my_int = 9;
extern "C" void nnMain()
{
    NTD_TEST_START();
    NTD_TEST_GROUP_START(TEST_NAME, 1);

    TESTLOG("GLOBAL_STATIC_CONSTRUCTORS_TYPE = GLOBAL_STATIC_CONSTRUCTORS_ONLY Part 1");
    TESTLOG("This TLS Constructor tests that a constructor will be called in the first function that has any thread_local variable referenced in it.");
    TESTLOG("The thread_local variable has to be visible in the compilation unit but it doesn't have to be the class object.  Any variable will do.");
    TESTLOG("Part 1 will have 2 such functions meeting that requirement. One function has 4 constructors and one function has 1 constructor.");

    nn::Result      result;
    long            num_dtrs_to_call = 0;
    nn::os::ThreadType *main_thread = nn::os::GetCurrentThread();
    TESTLOG("1: main_thread = 0x%08zX", (size_t)main_thread);
#if ENABLE_MY_INT
    my_int++;
#endif
    TESTCASE_MESSAGE(GameMinus == 0, "GameMinus when initialized: %d (expected 0)", GameMinus);
    // スレッドを生成する
    result = nn::os::CreateThread( &g_Thread1, TestThread, (void *)1, g_ThreadStack1, ThreadStackSize, nn::os::DefaultThreadPriority );
    NN_ASSERT( result.IsSuccess(), "Cannot create g_Thread1." );
    main_thread = nn::os::GetCurrentThread();
    TESTLOG("2: main_thread = 0x%08zX", (size_t)main_thread);

    TESTLOG("g_Thread1 = 0x%08zX", (size_t)&g_Thread1);
    main_thread = nn::os::GetCurrentThread();
    TESTLOG("3: main_thread = 0x%08zX", (size_t)main_thread);

    result = nn::os::CreateThread( &g_Thread2, TestThread, (void *)2, g_ThreadStack2, ThreadStackSize, nn::os::DefaultThreadPriority );
    NN_ASSERT( result.IsSuccess(), "Cannot create g_Thread2." );
    main_thread = nn::os::GetCurrentThread();
    TESTLOG("4: main_thread = 0x%08zX", (size_t)main_thread);

    TESTLOG("g_Thread2 = 0x%08zX", (size_t)&g_Thread2);
    main_thread = nn::os::GetCurrentThread();
    TESTLOG("5: main_thread = 0x%08zX", (size_t)main_thread);

    TESTLOG("Just before calling call_constructor");
    num_dtrs_to_call = __nnmusl_get_tls_dtors_status (__dso_handle);
#if ENABLE_MY_INT
    TESTCASE_MESSAGE(num_dtrs_to_call == 2, "Before calling call_constructor we expected 2 uncalled Destructor but we got %ld.", num_dtrs_to_call);
#else
    TESTCASE_MESSAGE(num_dtrs_to_call == 0, "Before calling call_constructor we expected 0 uncalled Destructor but we got %ld.", num_dtrs_to_call);
#endif
    call_constructor(4);
    num_dtrs_to_call = __nnmusl_get_tls_dtors_status (__dso_handle);
#if ENABLE_MY_INT
    TESTCASE_MESSAGE(num_dtrs_to_call == 2, "After calling call_constructor we expected 2 uncalled Destructor but we got %ld.", num_dtrs_to_call);
#else
    TESTCASE_MESSAGE(num_dtrs_to_call == 0, "After calling call_constructor we expected 0 uncalled Destructor but we got %ld.", num_dtrs_to_call);
#endif
    TESTLOG("Just after calling call_constructor");
    TESTLOG("Just before calling tls_horizon_2nd_file");
    num_dtrs_to_call = __nnmusl_get_tls_dtors_status (__dso_handle);
#if ENABLE_MY_INT
    TESTCASE_MESSAGE(num_dtrs_to_call == 2, "Before calling tls_horizon_2nd_file we expected 2 uncalled Destructor but we got %ld.", num_dtrs_to_call);
#else
    TESTCASE_MESSAGE(num_dtrs_to_call == 0, "Before calling tls_horizon_2nd_file we expected 0 uncalled Destructor but we got %ld.", num_dtrs_to_call);
#endif
    tls_horizon_2nd_file();
    num_dtrs_to_call = __nnmusl_get_tls_dtors_status (__dso_handle);
#if ENABLE_TLS_INT
    #if ENABLE_MY_INT
        TESTCASE_MESSAGE(num_dtrs_to_call == 3, "After calling tls_horizon_2nd_file we expected 3 uncalled Destructor but we got %ld.", num_dtrs_to_call);
    #else
        TESTCASE_MESSAGE(num_dtrs_to_call == 1, "After calling tls_horizon_2nd_file we expected 1 uncalled Destructor but we got %ld.", num_dtrs_to_call);
    #endif
#else
    #if ENABLE_MY_INT
        TESTCASE_MESSAGE(num_dtrs_to_call == 2, "After calling tls_horizon_2nd_file we expected 2 uncalled Destructor but we got %ld.", num_dtrs_to_call);
    #else
        TESTCASE_MESSAGE(num_dtrs_to_call == 0, "After calling tls_horizon_2nd_file we expected 0 uncalled Destructor but we got %ld.", num_dtrs_to_call);
    #endif
#endif
    TESTLOG("Just after calling tls_horizon_2nd_file");
    main_thread = nn::os::GetCurrentThread();
    TESTLOG("6: main_thread = 0x%08zX", (size_t)main_thread);

    num_dtrs_to_call = __nnmusl_get_tls_dtors_status (__dso_handle);
#if ENABLE_TLS_INT
    #if ENABLE_MY_INT
        TESTCASE_MESSAGE(num_dtrs_to_call == 3, "Before calling StartThread we expected 3 uncalled Destructor but we got %ld.", num_dtrs_to_call);
    #else
        TESTCASE_MESSAGE(num_dtrs_to_call == 1, "Before calling StartThread we expected 1 uncalled Destructor but we got %ld.", num_dtrs_to_call);
    #endif
#else
    #if ENABLE_MY_INT
        TESTCASE_MESSAGE(num_dtrs_to_call == 2, "Before calling StartThread we expected 2 uncalled Destructor but we got %ld.", num_dtrs_to_call);
    #else
        TESTCASE_MESSAGE(num_dtrs_to_call == 0, "Before calling StartThread we expected 0 uncalled Destructor but we got %ld.", num_dtrs_to_call);
    #endif
#endif

    // スレッドの実行を開始する
    nn::os::StartThread( &g_Thread1 );
    TESTLOG("g_Thread1 started");
    nn::os::StartThread( &g_Thread2 );
    TESTLOG("g_Thread2 started");

    // スレッドが終了するのを待つ
    nn::os::WaitThread( &g_Thread1 );
    TESTLOG("g_Thread1 did wait");
    nn::os::WaitThread( &g_Thread2 );
    TESTLOG("g_Thread2 did wait");

    // スレッドを破棄する
    nn::os::DestroyThread( &g_Thread1 );
    TESTLOG("g_Thread1 destroyed");
    nn::os::DestroyThread( &g_Thread2 );
    TESTLOG("g_Thread2 destroyed");

    TESTCASE_MESSAGE(GameMinus == -60, "GameMinus at main exit: %d (expected -50)", GameMinus);

    num_dtrs_to_call = __nnmusl_get_tls_dtors_status (__dso_handle);
    TESTLOG("There are %ld registered destructors at the end of nnMain.", num_dtrs_to_call);
#if ENABLE_TLS_INT
    #if ENABLE_MY_INT
        TESTCASE_MESSAGE(num_dtrs_to_call == 3, "Before exiting nnMain we expected 3 uncalled Destructor but we got %ld.", num_dtrs_to_call);
    #else
        TESTCASE_MESSAGE(num_dtrs_to_call == 1, "Before exiting nnMain we expected 1 uncalled Destructor but we got %ld.", num_dtrs_to_call);
    #endif
#else
    #if ENABLE_MY_INT
        TESTCASE_MESSAGE(num_dtrs_to_call == 2, "Before exiting nnMain we expected 2 uncalled Destructors but we got %ld.", num_dtrs_to_call);
    #else
        TESTCASE_MESSAGE(num_dtrs_to_call == 0, "Before exiting nnMain we expected 0 uncalled Destructors but we got %ld.", num_dtrs_to_call);
    #endif
#endif

    NTD_TEST_GROUP_END(TEST_NAME, 1);
    NTD_TEST_END();
}

