﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <cstdint>
#include <cstddef>
#include <cstdlib>
#include <pthread.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/os.h>
#include <nn/svc/svc_ThreadLocalRegion.h>
#include <climits>
#include <nn/os/os_ThreadApi.h>
#include "ntd-test-tls.h"

static size_t tdata_align_abs, tbss_align_abs, tdata_align_rel, tbss_align_rel, tls_segment_align;

extern "C" {
extern void call_at_atexit(void);
extern void call_at_atexit(void)
{
    printf("call_at_atexit was called.\n");
}
}

typedef struct atexit_element {
    size_t dtor;
    size_t obj;
    size_t dso_handle;
} atexit_element;

extern atexit_element            __atexit_start[] __attribute__((weak));
extern atexit_element            __atexit_end[] __attribute__((weak));

#define TEST_ROOT_NAME STRINGIZE_VALUE_OF(TLS_NRO_NAME)
#if ULONG_MAX == 0xffffffff
#define TEST_NAME "ARM32-" TEST_ROOT_NAME
#else
#define TEST_NAME "AARCH64-" TEST_ROOT_NAME
#endif

#define MIN_ALIGN nn::os::ThreadStackAlignment

extern void *__dso_handle;  // this is defined in Chris/Sources/Libraries/rocrt/rocrt.cpp

#define STACK_SIZE (3 * MIN_ALIGN)

const size_t            ThreadStackSize = STACK_SIZE;                 // スレッド操作スレッドのスタックサイズ
NN_OS_ALIGNAS_THREAD_STACK char  g_ThreadStack1[ ThreadStackSize ];   // 1つ目のスレッドのスタック
nn::os::ThreadType      g_Thread1;

class Hoge5
{
public:
    int x;
    nn::os::ThreadType *Hoge5_thread;
    void *this_obj;
    char *name = (char *)"<unitialized name>";
    Hoge5() {
        TESTLOG("1:1 Hello from class Hoge5");
        TESTLOG("1:2 Hello from class Hoge5 (%s)", name);
        TESTLOG("1:3 Hello from class Hoge5 (%s) %d", name, x);
        Hoge5_thread = nn::os::GetCurrentThread();
        TESTLOG("1:4 Hello from class Hoge5 (%s) %d thread address 0x%08zX", name, x, (size_t)Hoge5_thread);
        this_obj = (void*)this;
        TESTLOG("Hello from class Hoge5 (%s) %d thread address 0x%08zX; this = 0x%08zX", name, x, (size_t)Hoge5_thread,
            (size_t)this_obj);
    }
    Hoge5(char *func_name, int T) {
        TESTLOG("2:1 Hello from class Hoge5");
        name = func_name;
        TESTLOG("2:2 Hello from class Hoge5 (%s)", name);
        x = T;
        TESTLOG("2:3 Hello from class Hoge5 (%s) %d", name, x);
        Hoge5_thread = nn::os::GetCurrentThread();
        TESTLOG("2:4 Hello from class Hoge5 (%s) %d thread address 0x%08zX", name, x, (size_t)Hoge5_thread);
        this_obj = (void*)this;
        TESTLOG("Hello from class Hoge5 (%s) %d thread address 0x%08zX; this = 0x%08zX", name, x, (size_t)Hoge5_thread,
            (size_t)this_obj);
    }
    ~Hoge5() { TESTLOG("Good-bye from class Hoge5 (%s) %d thread address 0x%08zX; this = 0x%08zX!", name, x, (size_t)Hoge5_thread,
        (size_t)this_obj); }
};
thread_local Hoge5 g_Hoge5((char *)"g_Hoge5_0", 47);

// the following are the options and how they effect the NRO name
// ENABLE_G_HOGE9_W_CTOR == 1 Ax
// ENABLE_G_HOGE9_W_CTOR_USE == 1 Bx
// ENABLE_G_HOGE9_WO_CTOR == 1 Cx
// ENABLE_G_HOGE9_WO_CTOR_USE == 1 Fx
// All ENABLE_G_HOGE9_* == 0 Dx
// ENABLE_TLS_INT == 1 xE
// ENABLE_TLS_INT == 0 xD
#if ENABLE_G_HOGE9_W_CTOR || ENABLE_G_HOGE9_W_CTOR_USE
static Hoge5 g_Hoge9((char *)"g_Hoge9_0", -16);
#elif ENABLE_G_HOGE9_WO_CTOR || ENABLE_G_HOGE9_WO_CTOR_USE
static Hoge5 g_Hoge9;
#endif

#if ENABLE_TLS_INT
thread_local int tls_int;
#define AN_INT tls_int
#define AN_INT_NAME "tls_int"
#else
static int static_int;
#define AN_INT static_int
#define AN_INT_NAME "static_int"
#endif

static void test_tls_constructors(void *arg)
{
    TESTLOG("test_tls_constructors entered 1");
    NN_UNUSED(arg);
    long            num_dtrs_to_call = 0;
    int n, i, elements;
    atexit_element *the_element;
    size_t dtor, obj, dso_handle;
    size_t *start = (size_t *)__atexit_start;
    size_t *the_Dtor_ptr;
//    unsigned int instruction1, instruction2, instruction3;

    TESTLOG("test_tls_constructors entered 2");
    AN_INT = 7;
    TESTLOG("test_tls_constructors entered with %s = %d", (char *)AN_INT_NAME, AN_INT);
//    TESTLOG("test_tls_constructors: g_Hoge5 is 0x%08zX; ~Hoge5 is 0x%08zX", (size_t)(g_Hoge5), (size_t)(~Hoge5));
    n = (size_t)__atexit_end - (size_t)__atexit_start;
    elements = 0;
    if (n) {
        elements = n / sizeof(atexit_element);
    }
#if ENABLE_G_HOGE9_W_CTOR || ENABLE_G_HOGE9_WO_CTOR || ENABLE_G_HOGE9_W_CTOR_USE || ENABLE_G_HOGE9_WO_CTOR_USE
    TESTCASE_MESSAGE(elements == 1, "expected 1 uncalled non-thread_local Destructor but we got %ld.", elements);
#else
    TESTCASE_MESSAGE(elements == 0, "expected 0 uncalled non-thread_local Destructor but we got %ld.", elements);
#endif

    TESTLOG("__atexit_start is 0x%08zX; __atexit_end is 0x%08zX; .atexit size is 0x%08zX with %d elements", (size_t)__atexit_start, (size_t)__atexit_end, n, elements);
    for (i = 0; i < elements; i++) {
        the_element = &(__atexit_start[i]);
        TESTLOG("element[%d]: dtor is 0x%08zX; obj is 0x%08zX; dso_handle is 0x%08zX",
            i, (size_t)(the_element->dtor), (size_t)(the_element->obj), (size_t)(the_element->dso_handle));
    }
    TESTLOG("");
    for (i = 0; i < elements; i++) {
        dtor = *start;
        the_Dtor_ptr = start;
        start++;
        obj = *start;
        start++;
        dso_handle = *start;
        start++;
        TESTLOG("element[%d]: dtor is 0x%08zX; obj is 0x%08zX; dso_handle is 0x%08zX",
            i, (size_t)(dtor), (size_t)(obj), (size_t)(dso_handle));
    }
/*
    TESTLOG("");
    if (the_Dtor_ptr) {
        instruction1 = *the_Dtor_ptr;
        the_Dtor_ptr++;
        instruction2 = *the_Dtor_ptr;
        the_Dtor_ptr++;
        instruction3 = *the_Dtor_ptr;
        the_Dtor_ptr++;
        TESTLOG("dtor: i1 is 0x%08zX; i2 is 0x%08zX; i2 is 0x%08zX",
            instruction1, instruction2, instruction3);
    }
*/
    TESTLOG("test_tls_constructors exited with %s = %d", (char *)AN_INT_NAME, ++AN_INT);
    TESTLOG("test_tls_constructors calling __nnmusl_get_tls_dtors_status() for module with __dso_handle = 0x%08zX", __dso_handle);
    num_dtrs_to_call = __nnmusl_get_tls_dtors_status (__dso_handle);
#if ENABLE_TLS_INT
    TESTCASE_MESSAGE(num_dtrs_to_call == 1, "Before exiting nnMain we expected 1 uncalled Destructor but we got %ld.", num_dtrs_to_call);
#else
    TESTCASE_MESSAGE(num_dtrs_to_call == 0, "Before exiting nnMain we expected 0 uncalled Destructor but we got %ld.", num_dtrs_to_call);
#endif
}

extern void TestTls(void);
void TestTls()
{
    TESTLOG("Start %s", TEST_NAME);
    TESTLOG("__EX_start = %p", (unsigned char *)__EX_start);
    TESTLOG("__tdata_start = %p", (unsigned char *)__tdata_start);
    TESTLOG("__tdata_end = %p", (unsigned char *)__tdata_end);
    TESTLOG("__tdata_align_abs = %p", (unsigned char *)__tdata_align_abs);
    TESTLOG("__tdata_align_rel = %p", (unsigned char *)__tdata_align_rel);
    TESTLOG("__tbss_start = %p", (unsigned char *)__tbss_start);
    TESTLOG("__tbss_end = %p", (unsigned char *)__tbss_end);
    TESTLOG("__tbss_align_abs = %p", (unsigned char *)__tbss_align_abs);
    TESTLOG("__tbss_align_rel = %p", (unsigned char *)__tbss_align_rel);
    tdata_align_abs = (size_t)__tdata_align_abs - (size_t)__EX_start;
    TESTLOG("tdata_align_abs = %ld", tdata_align_abs);
    tdata_align_rel = (size_t)__tdata_align_rel - (size_t)__tdata_start;
    TESTCASE_MESSAGE(tdata_align_abs == tdata_align_rel, "Inconsistent alignment for ,tdata abs and rel");
    tbss_align_abs = (size_t)__tbss_align_abs - (size_t)__EX_start;
    TESTLOG("tbss_align_abs = %ld", tbss_align_abs);
    tbss_align_rel = (size_t)__tbss_align_rel - (size_t)__tbss_start;
    TESTCASE_MESSAGE(tbss_align_abs == tbss_align_rel, "Inconsistent alignment for ,tbss abs and rel");
    // ld and lld make an empty .tdata section  have alignment 1; gold does 0 alignment
    if (tdata_align_abs > 1) {
        TESTCASE_MESSAGE(tdata_align_abs >= tbss_align_abs, "Unexpected .tbss alignment greater than .tdata alignment");
    }
    tls_segment_align = (tdata_align_abs > tbss_align_abs) ? tdata_align_abs : tbss_align_abs;
    TESTLOG("tls_segment_align = %ld", tls_segment_align);

    TESTLOG("GLOBAL_STATIC_CONSTRUCTORS_TYPE = GLOBAL_STATIC_CONSTRUCTORS_ONLY Part 1");
    TESTLOG("This TLS Constructor tests that a constructor will be called in the first function that has any thread_local variable referenced in it.");
    TESTLOG("The thread_local variable has to be visible in the compilation unit but it doesn't have to be the class object.  Any variable will do.");
    TESTLOG("Part 1 will have 2 such functions meeting that requirement. One function has 4 constructors and one function has 1 constructor.");

//    TESTLOG("TestTls entered with %s = %d", (char *)AN_INT_NAME, AN_INT); this will cause g_Hoge5_0 constructor to be called just before AN_INT is used
    TESTLOG("TestTls is 0x%08zX; test_tls_constructors is 0x%08zX", (size_t)(TestTls), (size_t)(test_tls_constructors));
//    TESTLOG("TestTls: __cxa_atexit is 0x%08zX; _ZN12_GLOBAL__N_112CallFinalizeEPvP11AtExitEntryPmmm is 0x%08zX", (size_t)(__cxa_atexit), (size_t)(_ZN12_GLOBAL__N_112CallFinalizeEPvP11AtExitEntryPmmm));

    nn::Result      result;
    long            num_dtrs_to_call = 0;
    int atexit_result;
    nn::os::ThreadType *main_thread = nn::os::GetCurrentThread();
    TESTLOG("1: main_thread = 0x%08zX", (size_t)main_thread);
    atexit_result = atexit(call_at_atexit);
    TESTLOG("atexit returned %d", atexit_result);
#if ENABLE_G_HOGE9_W_CTOR_USE || ENABLE_G_HOGE9_WO_CTOR_USE
    g_Hoge9.x = 9;
#endif
    result = nn::os::CreateThread( &g_Thread1, test_tls_constructors, NULL, g_ThreadStack1, ThreadStackSize, nn::os::DefaultThreadPriority );
    NN_ASSERT( result.IsSuccess(), "Cannot create g_Thread1." );

    TESTLOG("g_Thread1 = 0x%08zX", (size_t)&g_Thread1);

    TESTLOG("2: main_thread = 0x%08zX", (size_t)main_thread);

    // スレッドの実行を開始する
    nn::os::StartThread( &g_Thread1 );
    TESTLOG("g_Thread1 started");

    // スレッドが終了するのを待つ
    nn::os::WaitThread( &g_Thread1 );
    TESTLOG("g_Thread1 did wait");

    // スレッドを破棄する
    nn::os::DestroyThread( &g_Thread1 );
    TESTLOG("g_Thread1 destroyed");

    TESTLOG("TestTls calling __nnmusl_get_tls_dtors_status() for module with __dso_handle = 0x%08zX", __dso_handle);
    num_dtrs_to_call = __nnmusl_get_tls_dtors_status (__dso_handle);
    TESTCASE_MESSAGE(num_dtrs_to_call == 0, "Before exiting nnMain we expected 0 uncalled Destructors but we got %ld.", num_dtrs_to_call);
    TESTLOG("End %s", TEST_NAME);
}


