﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

/* $Id$ */

/* PDCLib testing suite <_PDCLIB_test.h>

   This file is part of the Public Domain C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

/* -------------------------------------------------------------------------- */
/* Helper macros for test drivers                                             */
/* -------------------------------------------------------------------------- */

#ifndef NTD_TEST_TLS_H
#define NTD_TEST_TLS_H 1

/* _GUN_SOURCE for asprintf */
#ifndef _GNU_SOURCE
#define _GNU_SOURCE 1
#endif
#include <stdio.h>
#include <limits.h>
#include <string.h>
#include <assert.h>
#include <wchar.h>
#include <stdbool.h>
#include <stdlib.h>
#include <errno.h>
#include <time.h>
#include <math.h>
#include <float.h>

#ifdef __cplusplus
extern "C" {
#endif
#define PRINT_TEST_LOG 0
typedef int (*testfunc_ptr)();

#define STRINGIZE(x) #x
#define STRINGIZE_VALUE_OF(x) STRINGIZE(x)

extern unsigned char            __EX_start[] __attribute__((weak));
extern unsigned char            __tdata_start[] __attribute__((weak));
extern unsigned char            __tdata_end[] __attribute__((weak));
extern unsigned char            __tdata_align_abs[] __attribute__((weak));
extern unsigned char            __tdata_align_rel[] __attribute__((weak));
extern unsigned char            __tbss_start[] __attribute__((weak));
extern unsigned char            __tbss_end[] __attribute__((weak));
extern unsigned char            __tbss_align_abs[] __attribute__((weak));
extern unsigned char            __tbss_align_rel[] __attribute__((weak));
extern void * __get_tp();
extern void ntd_test_tls_exit(int value);

extern const char *short_path(const char *file);

extern void NTD_TEST_START(void);
extern void NTD_TEST_END(void);
extern void NTD_TEST_GROUP_START(const char *name, int level);
extern int NTD_TEST_GROUP_END(const char *name, int level);
extern void NTD_TESTCASE(bool passed, const char *file, int line, const char *expression);
extern void NTD_TESTCASE_KNOWN_FAILURE(const char *msg, bool passed, const char *file,
    int line, const char *expression);
extern void NTD_TESTCASE_KNOWN_FAILURE_MESSAGE(const char *msg, bool passed,
    const char *file, int line, const char *expression, const char *message, ...);
extern int NTD_TESTCASE_NOMESSAGE(bool passed);
extern int NTD_TESTCASE_RESULT(int passed, const char *file, int line,
    const char *expression);
extern int NTD_TESTCASE_MESSAGE(bool passed, const char *file, int line,
    const char *expression, const char *message, ...);
extern void NTD_TESTWARNING(const char *func, const char *message, ...);
extern void NTD_TESTLOG(const char *func, const char *message, ...);
extern int NTD_CURRENT_FAIL_COUNT(void);
extern void NTD_RUN_TESTS(testfunc_ptr tests[], const char *names[], int count);
extern FILE *NTD_TEST_TMPFILE(const char *func_name);
extern FILE *NTD_TEST_TMPDIR(const char *func_name);

/* TESTCASE() - generic test */
#define TESTCASE_NOMESSAGE( x ) NTD_TESTCASE_NOMESSAGE(x)
#define TESTCASE_SUCCESS() NTD_TESTCASE_NOMESSAGE(1)
#define TESTCASE_FAILURE() NTD_TESTCASE_NOMESSAGE(0)
#define TESTCASE( x ) NTD_TESTCASE(x, __FILE__, __LINE__, #x)
#define TESTCASE_RETURN_IF_FAILURE( x ) \
    do {    \
        TESTCASE(x);    \
        if (x) return;  \
    }
#define TESTCASE_KNOWN_FAILURE(msg, x) NTD_TESTCASE_KNOWN_FAILURE(msg, x, __FILE__, __LINE__, #x)
#define TESTCASE_KNOWN_FAILURE_MSG(msg, x, ...) NTD_TESTCASE_KNOWN_FAILURE_MESSAGE(msg, x, __FILE__, __LINE__, #x, __VA_ARGS__)
#define TESTCASE_RESULT( x ) NTD_TESTCASE_RESULT(x, __FILE__, __LINE__, #x)
#define TESTCASE_MESSAGE( x, ... ) NTD_TESTCASE_MESSAGE(x, __FILE__, __LINE__, #x, __VA_ARGS__)
#define TESTCASE_WITH_LINE( line, x, ... ) NTD_TESTCASE_MESSAGE(x, __FILE__, line, #x, __VA_ARGS__)
#define TESTCASE_STRINGS_MATCH(got, exp) \
    do {    \
        bool result = (got != NULL && exp != NULL && strcmp(got, exp) == 0); \
        TESTCASE_MESSAGE(result, "\n\tfound    '%s'\n\texpected '%s'", got, exp); \
   } while (0)
#define TESTCASE_STRINGS_MATCH_LENGTH(got, exp, size) \
    do {    \
        bool result = (got != NULL && exp != NULL && strncmp(got, exp, size) == 0); \
        TESTCASE_MESSAGE(result, "\n\tfound     '%s'\n\texpected '%s'", got, exp); \
   } while (0)

#define TESTCASE_NOREG( x )
#if PRINT_TEST_WARN
#define TESTWARN( ... ) NTD_TESTWARNING(__func__, __VA_ARGS__)
#else
#define TESTWARN( ... )
#endif

#if PRINT_TEST_LOG
#define TESTLOG( ... ) NTD_TESTLOG(__func__, __VA_ARGS__)
#else
#define TESTLOG( ... )
#endif

#if __NX__
#define HORIZON_KNOWN_FAILURE(msg, x) TESTCASE_KNOWN_FAILURE(msg, x)
#define HORIZON_KNOWN_FAILURE_MESSAGE(msg, x, ...) TESTCASE_KNOWN_FAILURE_MSG(msg, x, __VA_ARGS__)
#else
#define HORIZON_KNOWN_FAILURE(msg, x) TESTCASE(x)
#define HORIZON_KNOWN_FAILURE_MESSAGE(msg, x, ...) TESTCASE_MESSAGE(x ,__VA_ARGS__)
#endif
#if __arm__ || __aarch64__
#define ARM_KNOWN_FAILURE(msg, x) TESTCASE_KNOWN_FAILURE(msg, x)
#define ARM_KNOWN_FAILURE_MESSAGE(msg, x, ...) TESTCASE_KNOWN_FAILURE_MSG(msg, x, __VA_ARGS__)
#else
#define ARM_KNOWN_FAILURE(msg, x) TESTCASE(x)
#define ARM_KNOWN_FAILURE_MESSAGE(msg, x, ...) TESTCASE_MESSAGE(x ,__VA_ARGS)
#endif

#if 0
extern void delete_if_exists(const char *src_file, int line, const char *filename);
extern FILE *fopen_test(const char *src_file, int line, const char *filename, const char *mode);
extern FILE *freopen_test(const char *src_file, int line, const char *filename, const char *mode, FILE *infile);
extern size_t fwrite_test(const char *src_file, int line, const char *str, size_t size, size_t nitems, FILE *file);
extern size_t fwrite_string_test(const char *src_file, int line, const char *str, FILE *file);
extern size_t fread_test(const char *src_file, int line, char *str, size_t size, size_t nitems, FILE *file);
extern size_t fread_file_test(const char *src_file, int line, char **out_data, FILE *file);
extern int fclose_test(const char *src_file, int line, FILE *file, const char *filename, int delete);
extern void create_file_test(const char *src_file, int line, const char *filename, const char *str);
extern long int ftell_test(const char *src_file, int line, FILE *file);
extern int fseek_test(const char *src_file, int line, FILE *file, long int offset, int origin);
extern int fflush_test(const char *src_file, int line, FILE *file);
extern FILE *fmemopen_test(const char *src_file, int line, char *buf, size_t buf_len, const char *mode);
extern FILE *open_memstream_test(const char *src_file, int line, char **buf, size_t *buf_len);
extern void *malloc_test(const char *src_file, int line, size_t size);
extern void *calloc_test(const char *src_file, int line, size_t count, size_t size);
extern char *strcpy_test(const char *src_file, int line, char *dest, char *src);
extern char *strcat_test(const char *src_file, int line, char *dest, char *src);

#define DELETE_IF_EXISTS(filename) delete_if_exists(__FILE__, __LINE__, filename)

#define FOPEN_TEST(filename, mode) fopen_test(__FILE__, __LINE__, filename, mode)
#define FREOPEN_TEST(filename, mode, infile) freopen_test(__FILE__, __LINE__, filename, mode, infile)

#define FREAD_TEST(str, size, nitems, file) fread_test(__FILE__, __LINE__, str, size, nitems, file)
#define FREAD_FILE_TEST(buf, file) fread_file_test(__FILE__, __LINE__, buf, file)

#define FWRITE_TEST(str, size, nitems, file) fwrite_test(__FILE__, __LINE__, str, size, nitems, file)
#define FWRITE_STRING_TEST(str, file) fwrite_string_test(__FILE__, __LINE__, str, file)

#define FCLOSE_TEST(file, filename) fclose_test(__FILE__, __LINE__, file, filename, 0)
#define FCLOSE_TEST_NO_NAME(file) fclose_test(__FILE__, __LINE__, file, "", 0)
#define FCLOSE_DELETE_TEST(file, filename) fclose_test(__FILE__, __LINE__, file, filename, 1)

#define CREATE_FILE_TEST(filename, string) create_file_test(__FILE__, __LINE__, filename, string)

#define FTELL_TEST(file) ftell_test(__FILE__, __LINE__, file)

#define FSEEK_TEST(file, offset, origin) fseek_test(__FILE__, __LINE__, file, offset, origin)

#define FFLUSH_TEST(file) fflush_test(__FILE__, __LINE__, file)

#define FMEMOPEN_TEST(buf, buf_len, mode) fmemopen_test(__FILE__, __LINE__, buf, buf_len, mode)

#define OPEN_MEMSTREAM_TEST(buf, buf_len) open_memstream_test(__FILE__, __LINE__, buf, buf_len)

#define MALLOC_TEST(size) malloc_test(__FILE__, __LINE__, size)
#define CALLOC_TEST(count, size) calloc_test(__FILE__, __LINE__, count, size)

#define STRCPY_TEST(dest, src) strcpy_test(__FILE__, __LINE__, dest, src)
#define STRCAT_TEST(dest, src) strcat_test(__FILE__, __LINE__, dest, src)

#define NO_FERROR(file) TESTCASE_MESSAGE(ferror(file) == 0, \
    "ferror(%p) returned %d expected 0",   \
    file, ferror(file))

#if __NX__
#define HOST_FILENAME(string) "host:/" string
#define HOST_DIR_FILENAME(dir,file) "host:/" dir file
#else
#define HOST_FILENAME(string) string
#define HOST_DIR_FILENAME(dir,file) dir file
#endif

#endif

extern void addmillisecondsfromnow(struct timespec * time, int ms);

#define NTD_TEST_REGISTER_ALLOCATION(ptr) ntd_test_register_allocation(ptr, __FILE__, __LINE__, __FUNCTION__)

#ifdef __cplusplus
}
#endif
#endif

