﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

class SkyRenderer
{

public:

    SkyRenderer();
    ~SkyRenderer();

    void finalize();

    bool render( );

    void setup( nn::gfx::PrimitiveTopology topology, const char* pFilename );

    void setInvProjectionMatrix( float16 fV )
    {
        m_kInvProjectionMatrix = fV;
    }
    void setInvModelviewMatrix( float16 fV )
    {
        m_kInvModelviewMatrix = fV;
    }
    void setCameraDirection( float4 fV )
    {
        m_kCameraDirection = fV;
    }
    void setExposure( float f )
    {
        m_fExposure = make_float4( f, f, f, f );
    }
    void setSunAzimuth( float f )
    {
        m_fSunAzimuth = make_float4( f, f, f, f );
    }
protected:

    float4 *m_afVertexData;
    float4 m_kCameraDirection;
    float4 m_fExposure;
    float4 m_fSunAzimuth;
    float16 m_kInvProjectionMatrix;
    float16 m_kInvModelviewMatrix;

    int m_iVUniformsLoc;
    int m_iPUniformsLoc;

    nn::gfx::PrimitiveTopology m_Topology;
    DEMOGfxPipeline m_Pipeline;
    DEMOGfxBuffer m_PixelUniformBuffer;
    DEMOGfxBuffer m_VertexUniformBuffer;
    DEMOGfxBuffer m_VertexBuffer;

};
