/*-----------------------------------------------------------------------*
  Project: csGrass
  File: transform.vs

  Copyright (C) 2013 Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo and/or its licensed developers
  and are protected by national and international copyright laws. They
  may not be disclosed to third parties or copied or duplicated in any
  form, in whole or in part, without the prior written consent of
  Nintendo.

  The content herein is highly confidential and should be handled
  accordingly.
*-----------------------------------------------------------------------*/

struct VertexShaderInput
{
    float4 position : a_position;
    float4 color : a_color;
    uint instanceId : SV_InstanceID;
};

struct VertexShaderOutput
{
    float4 position : SV_POSITION;
    float4 color : color;
};

cbuffer u_InstancedMV : register( b0 )
{
    struct {
        float4 u_modelviewMtx0;
        float4 u_modelviewMtx1;
        float4 u_modelviewMtx2;
        float4 u_modelviewMtx3;
    } mv[25];                   // MaxFieldInstances from main.cpp
};

cbuffer u_VUniforms : register( b1 )
{
	matrix u_projMtx;
};



VertexShaderOutput main( VertexShaderInput input )
{
    VertexShaderOutput output;

	int instanceId = input.instanceId;
    matrix modelviewMtx = matrix( mv[ instanceId ].u_modelviewMtx0,
                                  mv[ instanceId ].u_modelviewMtx1,
                                  mv[ instanceId ].u_modelviewMtx2,
                                  mv[ instanceId ].u_modelviewMtx3 );

    output.color = input.color;

    // Matrix data is row-major
    modelviewMtx = transpose( modelviewMtx );

    output.position = mul( u_projMtx, mul( modelviewMtx, input.position ) );

    return output;
}
