﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "thread_test.h"
/* The header above includes other headers this file needs:
     #include <stdio.h>
*/
#include <semaphore.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
  #include "ntd-tests/ntd-tests.h"
#ifdef __cplusplus
}
#endif /* __cplusplus */

void test_sem_post()
{
    sem_t sem;
    int cur_value;
    int rc;
    const char *testcase = __FUNCTION__;

    NTD_TEST_GROUP_START("sem_post", 3);

    rc = sem_init(&sem, 0, 10);
    TESTCASE_MESSAGE(rc == 0, "sem_init(%p, 0, 10) returned %d expected 0", &sem, rc);

    rc = sem_getvalue(&sem, &cur_value);
    TESTCASE_MESSAGE(rc == 0, "sem_getvalue(%p, %p) returned %d expected 0",
        &sem, &cur_value, rc);

    TESTWARN("After sem_init() the value of the semaphore is %d\n", cur_value);

    rc = sem_post(&sem);
    TESTCASE_MESSAGE(rc == 0, "sem_post(%p) returned %d expected 0", &sem, rc);

    rc = sem_getvalue(&sem, &cur_value);
    TESTCASE_MESSAGE(rc == 0, "sem_getvalue(%p, %p) returned %d expected 0",
        &sem, &cur_value, rc);

    TESTWARN("After sem_post() the value of the semaphore is %d\n", cur_value);

    rc = sem_destroy(&sem);
    TESTCASE_MESSAGE(rc == 0, "sem_destroy(%p) returned %d expected 0", &sem, rc);

    NTD_TEST_GROUP_END("sem_post", 3);
}

#if 0
Debug output:

The initial value of the semaphore is 10
The value of the semaphore after the post is 11
#endif
