﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "thread_test.h"
/* The header above includes other headers this file needs:
     #include <stdio.h>
*/
#include <semaphore.h>
#include "ntd-tests/ntd-tests.h"

void test_sem_destroy()
{
    sem_t sem;
    int rc;

    NTD_TEST_GROUP_START("sem_destroy", 3);

    rc = sem_init(&sem, 0, 10);
    TESTCASE_MESSAGE(rc == 0, "sem_init(&sem = %p, 0, 10) returned %d",
        &sem, rc);

    rc = sem_destroy(&sem);
    TESTCASE_MESSAGE(rc == 0, "sem_destroy(&sem = %p) returned %d",
        &sem, rc);

    NTD_TEST_GROUP_END("sem_destroy", 3);
}
