﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "thread_test.h"
/* The header above includes other headers this file needs:
     #include <stdio.h>
*/
#include <pthread.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
  #include "ntd-tests/ntd-tests.h"
#ifdef __cplusplus
}
#endif /* __cplusplus */

#if SUPPORT_STATIC_INITALIZATION
static pthread_mutex_t    mutex = PTHREAD_MUTEX_INITIALIZER;
#else
static pthread_mutex_t    mutex;
#endif

void test_pthread_mutex_unlock()
{
  int                   rc=0;

  NTD_TEST_GROUP_START("mutex_unlock", 3);

#if !SUPPORT_STATIC_INITALIZATION
  rc = pthread_mutex_init(&mutex, NULL);
  TESTCASE_MESSAGE(rc == 0, "pthread_mutex_init(NULL) returned %d expected 0", rc);
#endif
  TESTWARN("Lock the mutex\n");
  rc = pthread_mutex_lock(&mutex);
  TESTCASE_MESSAGE(rc == 0, "pthread_mutex_lock() returned %d expected 0", rc);

  /* All other threads will be blocked from the resource here */

  TESTWARN("Unlock the mutex\n");
  rc = pthread_mutex_unlock(&mutex);
  TESTCASE_MESSAGE(rc == 0, "pthread_mutex_unlock() returned %d expected 0", rc);

  TESTWARN("Destroy the mutex\n");
  rc = pthread_mutex_destroy(&mutex);
  TESTCASE_MESSAGE(rc == 0, "pthread_mutex_destroy() returned %d expected 0", rc);

  NTD_TEST_GROUP_END("mutex_unlock", 3);
}

#if 0
Debug output:

Entering testcase
Lock the mutex
Unlock the mutex
Destroy the mutex
Main completed
#endif
