﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "thread_test.h"
/* The header above includes other headers this file needs:
     #include <stdio.h>
*/
#include <pthread.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
  #include "ntd-tests/ntd-tests.h"
#ifdef __cplusplus
}
#endif /* __cplusplus */

#if SUPPORT_STATIC_INITALIZATION
static pthread_mutex_t    mutex = PTHREAD_MUTEX_INITIALIZER;
#endif
static pthread_mutex_t    mutex2;
static pthread_mutex_t    mutex3;

void test_pthread_mutex_init()
{
  int                   rc=0;
  pthread_mutexattr_t   mta = {0}; /* mea initialized */

  NTD_TEST_GROUP_START("mutex_init", 3);

  TESTWARN("Create a default mutex attribute\n");
  rc = pthread_mutexattr_init(&mta);
  TESTCASE_MESSAGE(rc == 0, "pthread_mutexattr_init returned %d expected 0", rc);

  TESTWARN("Create the mutexes using the default mutex attributes\n");

  TESTWARN("First mutex created via static PTHREAD_MUTEX_INITIALIZER\n");

  TESTWARN("Create the mutex using the NULL attributes (default)\n");
  rc = pthread_mutex_init(&mutex3, NULL);
  TESTCASE_MESSAGE(rc == 0, "pthread_mutex_init(NULL) returned %d expected 0", rc);

  TESTWARN("Create the mutex using a mutex attributes object\n");
  rc = pthread_mutex_init(&mutex2, &mta);
  TESTCASE_MESSAGE(rc == 0, "pthread_mutex_init(mta) returned %d expected 0", rc);

  TESTWARN("- At this point, all mutexes can be used with their\n");
  TESTWARN("- default attributes from any threads that want to\n");
  TESTWARN("- use them\n");

  TESTWARN("Destroy all mutexes\n");
#if SUPPORT_STATIC_INITALIZATION
  pthread_mutex_destroy(&mutex);
#endif
  pthread_mutex_destroy(&mutex2);
  pthread_mutex_destroy(&mutex3);

  NTD_TEST_GROUP_END("mutex_init", 3);
}

#if 0
Debug output:

Enter Testcase - QP0WTEST/TPMTXINI0
Create a default mutex attribute
Create the mutexes using the default mutex attributes
First mutex created via static PTHREAD_MUTEX_INITIALIZER
Create the mutex using the NULL attributes (default)
Create the mutex using a mutex attributes object
- At this point, all mutexes can be used with their
- default attributes from any threads that want to
- use them
Destroy all mutexes
Main completed
#endif
