﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "thread_test.h"
/* The header above includes other headers this file needs:
     #include <stdio.h>
*/
#include <pthread.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
  #include "ntd-tests/ntd-tests.h"
#ifdef __cplusplus
}
#endif /* __cplusplus */

static pthread_key_t   tlsKey = 0;

static void globalDestructor(void *value)
{
  TESTWARN("In global data destructor\n");
  free(value);
  pthread_setspecific(tlsKey, NULL);
}

void test_pthread_key_delete()
{
  int                   rc=0;

  NTD_TEST_GROUP_START("key_delete", 3);

  TESTWARN("Create a thread local storage key\n");
  rc = pthread_key_create(&tlsKey, globalDestructor);
  TESTCASE_MESSAGE(rc == 0, "pthread_key_create() returned %d expected 0", rc);
  /* The key can now be used from all threads */

  TESTWARN("Delete a thread local storage key\n");
  rc = pthread_key_delete(tlsKey);
  TESTCASE_MESSAGE(rc == 0, "pthread_key_delete() returned %d expected 0", rc);

  TESTWARN("- The key should not be used from any thread\n");
  TESTWARN("- after destruction.\n");
  /* The key and any remaining values are now gone. */
  NTD_TEST_GROUP_END("key_delete", 3);
}

#if 0
Debug output:

Enter Testcase - QP0WTEST/TPKEYD0
Create a thread local storage key
Delete a thread local storage key
- The key should not be used from any thread
- after destruction.
Main completed
#endif
