﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "thread_test.h"
/* The header above includes other headers this file needs:
     #include <stdio.h>
     #include <stdlib.h>
*/
#include <pthread.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
  #include "ntd-tests/ntd-tests.h"
#ifdef __cplusplus
}
#endif /* __cplusplus */

#define         NUMTHREADS     3
static pthread_key_t   tlsKey = 0;
typedef struct thread_info {
    pthread_t           threadid;
    char                name[16];
} thread_info;
static thread_info      thread[NUMTHREADS];

static void globalDestructor(void *value)
{
  TESTWARN("In the globalDestructor\n");
  free(value);
  pthread_setspecific(tlsKey, NULL);
}


static void showGlobal(void)
{
  void                 *global;

  global  = pthread_getspecific(tlsKey);
  TESTWARN("showGlobal: global data retrieved for %s\n", (char *)global);
}

static void *threadfunc(void *parm)
{
  int           rc, i;
  char          *myThreadDataStructure;

  pthread_t     me = pthread_self();
  char *name = (char *)"Can not find thread";

  for (i = 0; i < NUMTHREADS; i++) {
    if (thread[i].threadid == me) {
        name = thread[i].name;
        break;
    }
  }

  TESTWARN("Inside secondary \"%s\"\n", name);

  myThreadDataStructure = (char *)malloc(sizeof(char) * 16);
  memcpy(myThreadDataStructure, name, sizeof(char) * 16);
  TESTWARN("showGlobal: global data stored for %s\n", name);
  pthread_setspecific(tlsKey, myThreadDataStructure);
  showGlobal();
  pthread_exit(NULL);
}

void test_pthread_getspecific()
{
  int                   rc=0;
  int                   i=0;
  const char *testcase = __FUNCTION__;

  NTD_TEST_GROUP_START("getspecific", 3);

  TESTWARN("Create a thread local storage key\n");
  rc = pthread_key_create(&tlsKey, globalDestructor);
  TESTCASE_MESSAGE(rc == 0, "pthread_key_create() returned %d expected 0", rc);
  /* The key can now be used from all threads */

  TESTWARN("Create %d threads using joinable attributes\n",
         NUMTHREADS);
  for (i=0; i<NUMTHREADS; ++i) {
    rc = pthread_create(&(thread[i].threadid), NULL, threadfunc, NULL);
    sprintf(thread[i].name, "thread %d", i);
    TESTCASE_MESSAGE(rc == 0, "pthread_create() returned %d expected 0", rc);
  }

  TESTWARN("Join to threads\n");
  for (i=0; i<NUMTHREADS; ++i) {
    rc = pthread_join(thread[i].threadid, NULL);
    TESTCASE_MESSAGE(rc == 0, "pthread_join() returned %d expected 0", rc);
  }

  TESTWARN("Delete a thread local storage key\n");
  rc = pthread_key_delete(tlsKey);
  TESTCASE_MESSAGE(rc == 0, "pthread_key_delete() returned %d expected 0", rc);
  /* The key and any remaining values are now gone. */
  NTD_TEST_GROUP_END("getspecific", 3);
}

#if 0
Debug output:

Enter Testcase - QP0WTEST/TPGETS0
Create a thread local storage key
Create 3 threads using joinable attributes
Join to threads
Inside secondary thread
showGlobal: global data stored for thread 0x000000000000000b
In the globalDestructor
Inside secondary thread
showGlobal: global data stored for thread 0x000000000000000d
In the globalDestructor
Inside secondary thread
showGlobal: global data stored for thread 0x000000000000000c
In the globalDestructor
Delete a thread local storage key
Main completed
#endif
