﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "thread_test.h"
/* The header above includes other headers this file needs:
     #include <stdio.h>
*/
#include <pthread.h>
#include <sched.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
  #include "ntd-tests/ntd-tests.h"
#ifdef __cplusplus
}
#endif /* __cplusplus */

static void showCondShared(pthread_condattr_t *a, int set_type, char *set_type_str)
{
    int                 rc=0;
    int                 type;
    char *              type_str;
    bool                test;

    rc = pthread_condattr_getpshared(a, &type);
    TESTCASE_MESSAGE(rc == 0, "pthread_condattr_getpshared() returned %d expected 0", rc);

    if (!rc) {
        if (type == PTHREAD_PROCESS_PRIVATE) {
            type_str = (char *)"PTHREAD_PROCESS_PRIVATE";
#if TEST_UNSUPPORTED_FEATURES
        } else if (type == PTHREAD_PROCESS_SHARED) {
            type_str = (char *)"PTHREAD_PROCESS_SHARED";
#endif
        } else {
            type_str = (char *)"UNKNOWN_COND_VAR_TYPE";
        }
        TESTWARN("The conditional variable attributes object indicates process shared: %s\n", type_str);
        test = (type == set_type);
        TESTCASE( test );
        if (!test) {
            TESTWARN("Failure: expected conditional variable process shared %s but pthread_condattr_getpshared returned %s\n",
                set_type_str, type_str);
        } else {
            TESTWARN("pthread_condattr_getpshared returned the expected conditional variable process shared: %s\n", set_type_str);
        }
    }
}

void test_pthread_condattr_setpshared()
{
    int                   rc=0;
    pthread_condattr_t    pca;
    bool                  test;

    NTD_TEST_GROUP_START("condattr_setpshared", 3);

    TESTWARN("Create a conditional variable attributes object\n");
    rc = pthread_condattr_init(&pca);
    TESTCASE_MESSAGE(rc == 0, "pthread_condattr_init() returned %d expected 0", rc);

    if (!rc) {
        showCondShared(&pca, 0, (char *)"PTHREAD_PROCESS_PRIVATE");
    } else {
        TESTWARN("Failed calling pthread_condattr_init\n");
    }

    rc = pthread_condattr_init(&pca);
    TESTCASE_MESSAGE(rc == 0, "pthread_condattr_init() returned %d expected 0", rc);

    TESTWARN("Setting mutex to PTHREAD_PROCESS_PRIVATE\n");
    rc = pthread_condattr_setpshared(&pca, PTHREAD_PROCESS_PRIVATE);
    TESTCASE_MESSAGE(rc == 0, "pthread_condattr_setpshared() returned %d expected 0", rc);
    if (!rc) {
        showCondShared(&pca, PTHREAD_PROCESS_PRIVATE, (char *)"PTHREAD_PROCESS_PRIVATE");
    } else {
        TESTWARN("Failed passing %s for mutex type\n", "PTHREAD_PROCESS_PRIVATE");
    }

    rc = pthread_condattr_init(&pca);
    TESTCASE_MESSAGE(rc == 0, "pthread_condattr_init() returned %d expected 0", rc);

#if TEST_UNSUPPORTED_FEATURES
    TESTWARN("Setting mutex to PTHREAD_PROCESS_SHARED\n");
    rc = pthread_condattr_setpshared(&pca, PTHREAD_PROCESS_SHARED);
    test = (rc == ENOTSUP);
    TESTCASE( test );
    if (test) {
        TESTWARN("tried an unsupported process shared and got the expected error 0x%x (this message is OK)\n", rc, __FILE__, __LINE__);
    } else if (rc) {
        TESTWARN("Unexpected error: passing %s for unsupported process shared returned 0x%x\n", "PTHREAD_PROCESS_SHARED", rc, __FILE__, __LINE__);
    } else {
        TESTWARN("Unexpected success: passing %s for unsupported process shared returned no error (this message is not OK)\n", "PTHREAD_PROCESS_SHARED");
        showCondShared(&pca, PTHREAD_PROCESS_SHARED, (char *)"PTHREAD_PROCESS_SHARED");
    }
#endif

    rc = pthread_condattr_init(&pca);
    TESTCASE_MESSAGE(rc == 0, "pthread_condattr_init() returned %d expected 0", rc);

#if TEST_UNSUPPORTED_FEATURES
    TESTWARN("Setting scope to 3\n");
    rc = pthread_condattr_setpshared(&pca, 3);
    test = (rc == EINVAL);
    TESTCASE( test );
    if (test) {
        TESTWARN("tried an unsupported process shared and got the expected error 0x%x (this message is OK)\n", rc, __FILE__, __LINE__);
    } else if (rc) {
        TESTWARN("Unexpected error: passing %s for unsupported process shared returned 0x%x\n", "3", rc, __FILE__, __LINE__);
    } else {
        TESTWARN("Unexpected success: passing %s for unsupported process shared returned no error (this message is not OK)\n", "3");
        showCondShared(&pca, 3, (char *)"3");
    }
#endif

    TESTWARN("Destroy conditional variable attributes object\n");
    rc = pthread_condattr_destroy(&pca);
    TESTCASE_MESSAGE(rc == 0, "pthread_condattr_destroy() returned %d expected 0", rc);

    NTD_TEST_GROUP_END("condattr_setpshared", 3);
}
