﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "thread_test.h"
/* The header above includes other headers this file needs:
     #include <stdio.h>
*/
#include <pthread.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
  #include "ntd-tests/ntd-tests.h"
#ifdef __cplusplus
}
#endif /* __cplusplus */

static pthread_cond_t              cond;

void test_pthread_cond_destroy()
{
    int                   rc=0;

    NTD_TEST_GROUP_START("cond_destroy", 3);

    TESTWARN("Create the condition using the condition attributes object\n");
    rc = pthread_cond_init(&cond, NULL);
    TESTCASE_MESSAGE(rc == 0, "pthread_cond_init() returned %d expected 0", rc);

    TESTWARN("- At this point, the condition with its default attributes\n");
    TESTWARN("- Can be used from any threads that want to use it\n");

    TESTWARN("Destroy condition\n");
    rc = pthread_cond_destroy(&cond);
    TESTCASE_MESSAGE(rc == 0, "pthread_cond_destroy() returned %d expected 0", rc);

    NTD_TEST_GROUP_END("cond_destroy", 3);
}

#if 0
Debug output:

Entering testcase
Create the condition using the condition attributes object
- At this point, the condition with its default attributes
- Can be used from any threads that want to use it
Destroy condition
Main completed
#endif
