﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "thread_test.h"
/* The header above includes other headers this file needs:
     #include <stdio.h>
     #include <string.h>
*/
#include <pthread.h>
#include <sched.h>

#define BUMP_PRIO 1
#define REDUCE_PRIO -2
static int thePriority = 0;

static void validate_sched_parameter(pthread_attr_t *a, int prio)
{
    int                 rc=0;
    struct sched_param  param;

    rc = pthread_attr_getschedparam(a, &param);
    TESTCASE_MESSAGE(rc == 0, "pthread_attr_getschedparam() returned %d expected 0", rc);

    TESTCASE_MESSAGE( param.sched_priority == prio,
        "Failure: expected priority %d but pthread_attr_getschedparam returned %d\n",
        prio, param.sched_priority);
    thePriority = param.sched_priority;
    return;
}

void test_pthread_attr_setschedparam_1()
{
    int                   rc=0;
    pthread_attr_t        pta;
    struct sched_param    param;

    NTD_TEST_GROUP_START("attr_setschedparam_1", 3);

    rc = pthread_attr_init(&pta);
    TESTCASE_MESSAGE(rc == 0, "pthread_attr_init() returned %d expected 0", rc);

    validate_sched_parameter(&pta, 0);

    memset(&param, 0, sizeof(param));
    if (thePriority + BUMP_PRIO <= sched_get_priority_min(SCHED_OTHER)) {
        param.sched_priority = thePriority + BUMP_PRIO;
    }

    rc = pthread_attr_setschedparam(&pta, &param);
    TESTCASE_MESSAGE(rc == 0, "pthread_attr_setschedparam() 1 returned %d expected 0", rc);

    validate_sched_parameter(&pta, param.sched_priority);

    memset(&param, 0, sizeof(param));
    if (thePriority + REDUCE_PRIO >= sched_get_priority_max(SCHED_OTHER)) {
        param.sched_priority = thePriority + REDUCE_PRIO;
    }

    rc = pthread_attr_setschedparam(&pta, &param);
    TESTCASE_MESSAGE(rc == 0, "pthread_attr_setschedparam() 2 returned %d expected 0", rc);

    validate_sched_parameter(&pta, param.sched_priority);

    memset(&param, 0, sizeof(param));
    param.sched_priority = sched_get_priority_max(SCHED_OTHER);

    rc = pthread_attr_setschedparam(&pta, &param);
    TESTCASE_MESSAGE(rc == 0, "pthread_attr_setschedparam() 3 returned %d expected 0", rc);

    validate_sched_parameter(&pta, param.sched_priority);

    memset(&param, 0, sizeof(param));
    param.sched_priority = sched_get_priority_min(SCHED_OTHER);

    rc = pthread_attr_setschedparam(&pta, &param);
    TESTCASE_MESSAGE(rc == 0, "pthread_attr_setschedparam() 4 returned %d expected 0", rc);

    validate_sched_parameter(&pta, param.sched_priority);

    TESTWARN("Destroy thread attributes object\n");
    rc = pthread_attr_destroy(&pta);
    TESTCASE_MESSAGE(rc == 0, "pthread_attr_destroy() returned %d expected 0", rc);

    NTD_TEST_GROUP_END("attr_setschedparam_1", 3);
}

#if 0
Debug Output:

Enter Testcase - QP0WTEST/TASSP0
Create a thread attributes object
Get scheduling parameters
The thread attributes object indicates priority: 0
Setting scheduling parameters
Get scheduling parameters
The thread attributes object indicates priority: 0
Destroy thread attributes object
Main completed
#endif
